#include <allegro.h>
#include "winalleg.h"
#include "commctrl.h"
#include <process.h>
#include <aldumb.h>
#include <math.h>
//#include "dotmodat.h"
typedef struct VX {int u,v;float x,y,z;} VX;

typedef struct MODULE
  {
    unsigned char
         title[20],
         samples_data[31][30],
         n_order,
         order[128],
         n_pattern,
         pattern[128][64][4][6],
         fix7f,
         mk[4],
         pattern_flags[128],
         pstring[128][64][128],
         filename[256],
         cur_pattern,
         cur_order,
         cur_row,
         cur_data[4][6],
         chan_bass,
         chan_perc,
         chan_melody,
         chan_arp,
         chan_max,
         chan_min,
         onoff[4],
         playing,
         play,stop;

    unsigned long int
         notecount[129][5],
         pitchcount[4],
         arpcount[4],
         smpcount[4][32],
         diffcount[13][4];
    DUH *duh;          /* Encapsulates the music file. */
	  AL_DUH_PLAYER *dp; /* Holds the current playback state. */
	  DUMB_IT_SIGDATA *sd;
	  DUH_SIGRENDERER *duhsr;
	  DUMB_IT_SIGRENDERER *itsr;
  } MODULE;



MODULE *module1,*module2;
int current_speed,desired_speed,desired_tempo,koff[10];
static int mod1,mod2;
float poscent;
volatile int sec,row;
	static volatile int closed = 0;
	static void closehook(void) { closed = 1; }
	#	define YIELD() Sleep(1)
BITMAP *page1, *page2, *bg;
BITMAP *active_page;
DATAFILE *data;

	char modd[256],tmp[64],tmp2[128],bufa[256];
int notes[60]=
       {1712,1616,1525,1440,1357,1281,1209,1141,1077,1017, 961, 907,
        856, 808, 762, 720, 678, 640, 604, 570, 538, 508, 480, 453,
        428, 404, 381, 360, 339, 320, 302, 285, 269, 254, 240, 226,
        214, 202, 190, 180, 170, 160, 151, 143, 135, 127, 120, 113,
        107, 101,  95,  90,  85,  80,  76,  71,  67,  64,  60,  57};
char octave[13][3]={"C","C#","D","D#","E","F","F#","G","G#","A","A#","B","--"};

void timingproc();


	static int loop_callback(void *data)
	{
		(void)data;
		return 0;
	}

	static int xm_speed_zero_callback(void *data)
	{
		(void)data;
		return 0;
	}


MODULE *read_mod(const char* filename)
{
  FILE *f;
  MODULE *mod;
  unsigned char title[20],sample[30],norder,fix7f,orders[128],mk[4],pattern[1024],division[4],npats,last,lastn;
  int c,n,row,chn,soct,snot;
  long int tmp;
  mod = malloc(sizeof(MODULE));
  f=fopen(filename,"rb");
  fread(title,1,20,f);
  memcpy(mod->title,title,20);

  for (c=0;c<31;c++)
  {
    fread(sample,1,30,f);
    memcpy(mod->samples_data[c],sample,30);
  }


  norder=fgetc(f);
  mod->n_order=norder;
  fix7f=fgetc(f);
  mod->fix7f=fix7f;
  fread(orders,1,0x80,f);
  memcpy(mod->order,orders,128);
  npats=0;
  for (c=0;c<norder;c++)
  {
    if (orders[c]>npats) npats=orders[c];
  }
  mod->n_pattern=npats;

  fread(mk,1,4,f);
  memcpy(mod->mk,mk,4);
  for (c=0;c<=npats;c++)
  {
    fread(pattern,1,1024,f);
    for(row=0;row<256;row++)
    {
      division[0]=pattern[row*4];
      division[1]=pattern[row*4+1];
      division[2]=pattern[row*4+2];
      division[3]=pattern[row*4+3];
      tmp=0;
      tmp=division[0];
      tmp&=0xf;
      tmp=tmp<<8;
      tmp= tmp + division[1];
      snot=0;
     // if (tmp)
     // {
      for (n=0;n<60;n++)
      {
        if (tmp==notes[n]) {snot=n;n=60;}
      }
      if (tmp)
      {
        mod->pattern[c][row/4][row%4][0]=snot%12;
        mod->pattern[c][row/4][row%4][1]=snot/12;

      } else {
        mod->pattern[c][row/4][row%4][0]=12;
        mod->pattern[c][row/4][row%4][1]=0;

      }
      tmp=0;
      tmp=division[2];
      tmp&=0xf0;
      tmp=tmp>>4;
      tmp=tmp | (division[0]&0xf0);


      mod->pattern[c][row/4][row%4][2]=division[2] & 0xf;
      mod->pattern[c][row/4][row%4][3]=division[3];
      mod->pattern[c][row/4][row%4][4]=tmp;
    //  } else mod->pattern[c][row/4][row%4][0]=0xff;
    }
  }
  fclose(f);
  memcpy(mod->filename,filename,256);
  return mod;
}

void print_mod(MODULE *mod)
{
  int p,c,i;
  printf("Title: %s\n\n",mod->title);
  for (c=0;c<31;c++) printf("Sample %i text:\n",c,mod->samples_data[c]);
  printf("\nPatterns played: %i\n",mod->n_order);
  printf("Pattern order: ");
  for (c=0;c<=mod->n_order;c++) printf("%2i ",mod->order[c]);
  printf("\n\nNumber of patterns: %i\n",mod->n_pattern);
  printf("Pattern data:\n");
  for(p=0;p<=mod->n_pattern;p++)
  {
   printf("Pattern %i\n",p);
   printf("Channel 0\tChannel 1\tChannel 2\tChannel 3\n");
   for (c=0;c<64;c++)
   {
    for (i=0;i<4;i++)
    {
      printf("%2s-%i %2i %X%2X\t",octave[mod->pattern[p][c][i][0]],
                                 mod->pattern[p][c][i][1],
                                 mod->pattern[p][c][i][4],
                                 mod->pattern[p][c][i][2],
                                 mod->pattern[p][c][i][3]);
    }
    printf("\n");
   }
  }
  printf("\nEND OF MODULE DATA\n");
}

int big(unsigned long int a,unsigned long int b,unsigned long int c,unsigned long int d)
{


  if (a>=b)
  {
  //  printf("0:%i\t1:%i\t2:%i\t3:%i\n",a,b,c,d);
    if (a>=c)
    {
      if (a>=d) {return 0;} else {return 3;}
    } else {
      if (c>=d) {return 2;} else {return 3;}
    }
  } else {
    if (b>=c)
    {
      if (b>=d) {return 1;} else {return 3;}
    } else {
      if (c>=d) {return 2;} else {return 3;}
    }
  }

}

int lil(unsigned long int a,unsigned long int b,unsigned long int c,unsigned long int d)
{
  //printf("0:%i\t1:%i\t2:%i\t3:%i\n",a,b,c,d);
  if (a<=b)
  {
    if (a<=c)
    {
      if (a<=d) {return 0;} else {return 3;}
    } else {
      if (c<=d) {return 2;} else {return 3;}
    }
  } else {
    if (b<=c)
    {
      if (b<=d) {return 1;} else {return 3;}
    } else {
      if (c<=d) {return 2;} else {return 3;}
    }
  }

}

void analyze_mod(MODULE *mod)
{

  int p,c,i,s,smp,bass,perc,arp,max,min,mel;
  unsigned char chanflags,last,lastn;

  for (i=0;i<4;i++)
  {
    for(p=0;p<mod->n_pattern;p++)
    {
      mod->notecount[p][i]=0;
      mod->notecount[p][4]=0;
    }
    for (c=0;c<31;c++) mod->smpcount[i][c]=0;
    mod->pitchcount[i]=0;
    mod->arpcount[i]=0;
    mod->smpcount[i][31]=0;

    mod->notecount[128][i]=0;
   printf("notes:%i %i %i %i %i\n",i,mod->notecount[128][0],mod->notecount[128][1],mod->notecount[128][2],mod->notecount[128][3]);
    for (c=0;c<12;c++) mod->diffcount[c][i]=0;
    mod->diffcount[12][i]=0;
  }


  mod->notecount[128][4]=0;
  printf("\nFile %s analysis details:\n",modd);
  for(p=0;p<=mod->n_pattern;p++)
  {
  printf("Pt:%2i\t",p);
  for (i=0;i<4;i++)
  {
   // printf("Channel:%i\n",i);
    for (c=0;c<64;c++)
    {
      if (mod->pattern[p][c][i][0]!=12)
      {
        mod->notecount[p][i]++;
        mod->notecount[p][4]++;
        mod->notecount[128][i]++;
        mod->notecount[128][4]++;
        mod->diffcount[mod->pattern[p][c][i][0]][i]=1;
        mod->pitchcount[i]+=mod->pattern[p][c][i][1];
        mod->smpcount[i][mod->pattern[p][c][i][4]]=1;
        mod->pattern[p][lastn][i][5]=last;
        last=1;lastn=c;
      } else  last++;
      if (mod->pattern[p][c][i][2]==0 && mod->pattern[p][c][i][3]!=0) mod->arpcount[i]++;

    }
    mod->pattern[p][lastn][i][5]=last;
    printf("%i:%2i\t",i,mod->notecount[p][i]);

  }

  printf("Total:%i\n",mod->notecount[p][4]);
  }
  for (c=0;c<31;c++)
  {
    for (i=0;i<4;i++)
    {
      if (mod->smpcount[i][c]) mod->smpcount[i][31]++;
    }
  }
  printf("OK!\n");

  for (i=0;i<4;i++)
  {
    mod->pitchcount[i]*=100;
    if (mod->notecount[128][i]) mod->pitchcount[i]/=mod->notecount[128][i];
    for (c=0;c<12;c++) mod->diffcount[12][i]+=mod->diffcount[c][i];
  }

printf("OK!\n");
  bass=lil(mod->pitchcount[0],mod->pitchcount[1],mod->pitchcount[2],mod->pitchcount[3]);
  perc=lil(mod->diffcount[12][0],mod->diffcount[12][1],mod->diffcount[12][2],mod->diffcount[12][3]);
  arp=big(mod->arpcount[0],mod->arpcount[1],mod->arpcount[2],mod->arpcount[3]);
  if (bass==perc) perc=big(mod->smpcount[0][31],mod->smpcount[1][31],mod->smpcount[2][31],mod->smpcount[3][31]);
  printf("OK!\n");
  if (mod->arpcount[0]==0 && mod->arpcount[1]==0 && mod->arpcount[2]==0 && mod->arpcount[3]==0)
  {
    chanflags=(int)pow(2,bass) | (int)pow(2,perc);
    printf("No arpeggios!\n");
    if (chanflags==0x3) {arp=3;mel=2;}
    if (chanflags==0x5) {arp=3;mel=1;}
    if (chanflags==0x6) {arp=3;mel=0;}
    if (chanflags==0x9) {arp=2;mel=1;}
    if (chanflags==0xA) {arp=2;mel=0;}
    if (chanflags==0xC) {arp=1;mel=0;}
  } else {
    if (arp==bass || arp==perc)
    {
      chanflags=(int)pow(2,bass) | (int)pow(2,perc);
      printf("Arpeggio bass/perc!\n");
      //printf("Chanflags:%X",chanflags);
      if (chanflags==0x3) {arp=3;mel=2;}
      if (chanflags==0x5) {arp=3;mel=1;}
      if (chanflags==0x6) {arp=3;mel=0;}
      if (chanflags==0x9) {arp=2;mel=1;}
      if (chanflags==0xA) {arp=2;mel=0;}
      if (chanflags==0xC) {arp=1;mel=0;}
    } else {
      chanflags=(int)pow(2,bass) | (int)pow(2,perc) | (int)pow(2,arp);
      printf("Arpeggios OK!\n");
      if (chanflags==0x7) {mel=3;}
      if (chanflags==0xB) {mel=2;}
      if (chanflags==0xD) {mel=1;}
      if (chanflags==0xE) {mel=0;}
    }
  }
  printf("Chanflags:%X\n",chanflags);
  //printf("Littlest:%i\n",lil(256,263,247,235));


  max=big(mod->notecount[128][0],mod->notecount[128][1],mod->notecount[128][2],mod->notecount[128][3]);
  min=lil(mod->notecount[128][0],mod->notecount[128][1],mod->notecount[128][2],mod->notecount[128][3]);
  mod->chan_bass=bass;
  mod->chan_arp=arp;
  mod->chan_perc=perc;
  mod->chan_melody=mel;
  mod->chan_max=max;
  mod->chan_min=min;
  printf("Bass channel: %i\nDrum channel: %i\nArpeggio channel: %i\nMelody channel: %i\nMin channel: %i\nMax channel: %i\n",bass,perc,arp,mel,max,min);
  printf("\nOverall notes: %i\n",mod->notecount[128][4]);
  printf("Channel notes:\t0:%i\t1:%i\t2:%i\t3:%i\n",mod->notecount[128][0],mod->notecount[128][1],mod->notecount[128][2],mod->notecount[128][3]);
  printf("Channel diffs:\t0:%i\t1:%i\t2:%i\t3:%i\n",mod->diffcount[12][0],mod->diffcount[12][1],mod->diffcount[12][2],mod->diffcount[12][3]);
  printf("Channel pitch:\t0:%i\t1:%i\t2:%i\t3:%i\n",mod->pitchcount[0],mod->pitchcount[1],mod->pitchcount[2],mod->pitchcount[3]);
  printf("Channel samps:\t0:%i\t1:%i\t2:%i\t3:%i\n",mod->smpcount[0][31],mod->smpcount[1][31],mod->smpcount[2][31],mod->smpcount[3][31]);
  printf("Channel arps:\t0:%i\t1:%i\t2:%i\t3:%i\n",mod->arpcount[0],mod->arpcount[1],mod->arpcount[2],mod->arpcount[3]);


  for (p=0;p<=mod->n_pattern;p++)
  {
    for (c=0;c<64;c++)
    {
      memcpy(mod->cur_data,mod->pattern[p][c],24);
      sprintf(mod->pstring[p][c],"%2s-%i %2s-%i %2s-%i %2s-%i",
                                 octave[mod->cur_data[0][0]],
                                 mod->cur_data[0][1],
                                 octave[mod->cur_data[1][0]],
                                 mod->cur_data[1][1],
                                 octave[mod->cur_data[2][0]],
                                 mod->cur_data[2][1],
                                 octave[mod->cur_data[3][0]],
                                 mod->cur_data[3][1]);
    }
  }
  mod->onoff[0]=1;
  mod->onoff[1]=1;
  mod->onoff[2]=1;
  mod->onoff[3]=1;
  mod->playing=0;
  mod->play=0;
  mod->stop=0;
  printf("\nEND OF ANALYSIS\n");
  // VARINIT


}

void draw()
{
  int c;
  if (mod1)
  {
  for (c=0;c<64;c++)
  {
    textout_ex(active_page, font, module1->pstring[module1->cur_pattern][c], (c<32 ? 5 : 160), (c<32 ? 160+(c*10) : 160+((c-32)*10)), (c==module1->cur_row ? makecol(192,255,192) : makecol(0,255,0)), -1);
  }
  for (c=0;c<module1->n_order;c++)
  {
     textprintf_ex(active_page, font, 5+(c*8), 140,(c==module1->cur_order ? makecol(255, 255, 255) : makecol(128, 192, 128)), -1,"%i",module1->order[c]);
  }
  textprintf_ex(active_page, font, 5, 150,makecol(128, 255, 128), -1,"  1    2    3    4");
  textprintf_ex(active_page, font, 160, 150,makecol(128, 255, 128), -1,"  1    2    3    4");

  textprintf_centre_ex(active_page, font, 120, 10 ,makecol(128, 255, 64), -1,"GREENISH MOD INFO");
  textprintf_centre_ex(active_page, font, 120, 20 ,makecol(128, 255, 64), -1,"FILE: %s",module1->filename);
  textprintf_centre_ex(active_page, font, 120, 30 ,makecol(128, 255, 64), -1,"NOTE NUMBER: %i",module1->notecount[128][4]);
  textprintf_centre_ex(active_page, font, 120, 40 ,makecol(128, 255, 64), -1,"BASS CHANNEL: %i",module1->chan_bass);
  textprintf_centre_ex(active_page, font, 120, 50 ,makecol(128, 255, 64), -1,"ARPEGGIO CHANNEL: %i",module1->chan_arp);
  textprintf_centre_ex(active_page, font, 120, 60 ,makecol(128, 255, 64), -1,"DRUMS CHANNEL: %i",module1->chan_perc);
  textprintf_centre_ex(active_page, font, 120, 70 ,makecol(128, 255, 64), -1,"MELODY CHANNEL: %i",module1->chan_melody);

  textprintf_ex(active_page, font, 10, 90  ,(module1->onoff[0] ? makecol(128, 255, 64) : makecol(64, 128, 32)), -1, (module1->onoff[0] ? "CHANNEL 1:  ON [1]" : "CHANNEL 1: OFF [1]"));
  textprintf_ex(active_page, font, 10, 100 ,(module1->onoff[1] ? makecol(128, 255, 64) : makecol(64, 128, 32)), -1, (module1->onoff[1] ? "CHANNEL 2:  ON [2]" : "CHANNEL 2: OFF [2]"));
  textprintf_ex(active_page, font, 10, 110 ,(module1->onoff[2] ? makecol(128, 255, 64) : makecol(64, 128, 32)), -1, (module1->onoff[2] ? "CHANNEL 3:  ON [3]" : "CHANNEL 3: OFF [3]"));
  textprintf_ex(active_page, font, 10, 120 ,(module1->onoff[3] ? makecol(128, 255, 64) : makecol(64, 128, 32)), -1, (module1->onoff[3] ? "CHANNEL 4:  ON [4]" : "CHANNEL 4: OFF [4]"));

   textprintf_centre_ex(active_page, font, 240, 100 ,makecol(128, 255, 64), -1,(module1->play ? (module1->playing ? "PLAYING" : "PENDING") : "PLAY [F2]"));
  //textprintf_centre_ex(active_page, font, 240, 110 ,makecol(128, 255, 64), -1,"STOP [F3]");

  }

  if (mod2)
  {

  for (c=0;c<64;c++)
  {
    textout_ex(active_page, font, module2->pstring[module2->cur_pattern][c], (c<32 ? 325 : 480), (c<32 ? 160+(c*10) : 160+((c-32)*10)), (c==module2->cur_row ? makecol(255,255,192) : makecol(255,255,0)), -1);
  }

    textprintf_ex(active_page, font, 325, 150,makecol(255, 255, 128), -1,"  1    2    3    4");
    textprintf_ex(active_page, font, 480, 150,makecol(255, 255, 128), -1,"  1    2    3    4");

  for (c=0;c<module2->n_order;c++)
  {
    textprintf_ex(active_page, font, 325+(c*8), 140,(c==module2->cur_order ? makecol(255, 255, 255) : makecol(192, 128, 64)), -1,"%i",module2->order[c]);
  }

  textprintf_ex(active_page, font, 330, 90  ,(module2->onoff[0] ? makecol(255, 255, 64) : makecol(128, 128, 32)), -1, (module2->onoff[0] ? "CHANNEL 1:  ON [5]" : "CHANNEL 1: OFF [5]"));
  textprintf_ex(active_page, font, 330, 100 ,(module2->onoff[1] ? makecol(255, 255, 64) : makecol(128, 128, 32)), -1, (module2->onoff[1] ? "CHANNEL 2:  ON [6]" : "CHANNEL 2: OFF [6]"));
  textprintf_ex(active_page, font, 330, 110 ,(module2->onoff[2] ? makecol(255, 255, 64) : makecol(128, 128, 32)), -1, (module2->onoff[2] ? "CHANNEL 3:  ON [7]" : "CHANNEL 3: OFF [7]"));
  textprintf_ex(active_page, font, 330, 120 ,(module2->onoff[3] ? makecol(255, 255, 64) : makecol(128, 128, 32)), -1, (module2->onoff[3] ? "CHANNEL 4:  ON [8]" : "CHANNEL 4: OFF [8]"));

  textprintf_centre_ex(active_page, font, 520, 10 ,makecol(255, 255, 64), -1,"YELLOWISH MOD INFO");
  textprintf_centre_ex(active_page, font, 520, 20 ,makecol(255, 255, 64), -1,"FILE: %s",module2->filename);
  textprintf_centre_ex(active_page, font, 520, 30 ,makecol(255, 255, 64), -1,"NOTE NUMBER: %i",module2->notecount[128][4]);
  textprintf_centre_ex(active_page, font, 520, 40 ,makecol(255, 255, 64), -1,"BASS CHANNEL: %i",module2->chan_bass);
  textprintf_centre_ex(active_page, font, 520, 50 ,makecol(255, 255, 64), -1,"ARPEGGIO CHANNEL: %i",module2->chan_arp);
  textprintf_centre_ex(active_page, font, 520, 60 ,makecol(255, 255, 64), -1,"DRUMS CHANNEL: %i",module2->chan_perc);
  textprintf_centre_ex(active_page, font, 520, 70 ,makecol(255, 255, 64), -1,"MELODY CHANNEL: %i",module2->chan_melody);

  textprintf_centre_ex(active_page, font, 560, 100 ,makecol(255, 255, 64), -1,(module2->play ? (module2->playing ? "PLAYING" : "PENDING") : "PLAY [F6]"));
  //textprintf_centre_ex(active_page, font, 560, 110 ,makecol(255, 255, 64), -1,"STOP [F7]");

  }



  textprintf_centre_ex(active_page, font, SCREEN_W/2, 30 ,makecol(0, 255, 255), -1,"[A] - SPEED + [Q]");
  textprintf_centre_ex(active_page, font, SCREEN_W/2, 40 ,makecol(255, 255, 255), -1,"%i",desired_speed);
  textprintf_centre_ex(active_page, font, SCREEN_W/2, 50 ,makecol(0, 255, 255), -1,"[S] - TEMPO + [W]");
  textprintf_centre_ex(active_page, font, SCREEN_W/2, 60 ,makecol(255, 255, 255), -1,"%i",desired_tempo);

  textprintf_centre_ex(active_page, font, 240, 90  ,makecol(128, 255, 64), -1,"OPEN [F1]");

  textprintf_centre_ex(active_page, font, 560, 90  ,makecol(255, 255, 64), -1,"OPEN [F5]");

}
void stop1()
{
  al_stop_duh(module1->dp);
  unload_duh(module1->duh);
  free(module1);
  mod1=0;
}

void stop2()
{
  al_stop_duh(module2->dp);
  unload_duh(module2->duh);
  free(module2);
  mod2=0;
}
void __stdcall open1()
{
    OPENFILENAME ofn;
    char szFileName[MAX_PATH] = "";
    int pixel,x,y,z,tpx,no,zz1,zz2;
    if (mod1) {mod1=0;stop1();}
    ZeroMemory(&ofn, sizeof(ofn));

    ofn.lStructSize = sizeof(ofn); // SEE NOTE BELOW
    ofn.hwndOwner = win_get_window();
    ofn.lpstrFilter = "MODZ ONLY (*.mod)\0*.mod\0All Files (*.*)\0*.*\0";
    ofn.lpstrFile = szFileName;
    ofn.nMaxFile = MAX_PATH;
    ofn.Flags = OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
    ofn.lpstrDefExt = "mod";
    set_color_conversion(COLORCONV_TOTAL);
    if(GetOpenFileName(&ofn))
    {

      module1=read_mod(szFileName);
      //print_mod(module1);
      analyze_mod(module1);
      mod1=1;
    }
}

void __stdcall open2()
{
    OPENFILENAME ofn;
    char szFileName[MAX_PATH] = "";
    int pixel,x,y,z,tpx,no,zz1,zz2;
    if (mod2) {mod2=0;stop2();}
    ZeroMemory(&ofn, sizeof(ofn));

    ofn.lStructSize = sizeof(ofn); // SEE NOTE BELOW
    ofn.hwndOwner = win_get_window();
    ofn.lpstrFilter = "MODZ ONLY (*.mod)\0*.mod\0All Files (*.*)\0*.*\0";
    ofn.lpstrFile = szFileName;
    ofn.nMaxFile = MAX_PATH;
    ofn.Flags = OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
    ofn.lpstrDefExt = "mod";
    set_color_conversion(COLORCONV_TOTAL);
    if(GetOpenFileName(&ofn))
    {


      module2=read_mod(szFileName);
      //print_mod(module2);
      analyze_mod(module2);
      mod2=1;
    }
}



void play1()
{
  module1->duh = dumb_load_mod_quick(module1->filename);
  dumb_it_do_initial_runthrough(module1->duh);
  module1->sd = duh_get_it_sigdata(module1->duh);

  module1->dp = al_start_duh(module1->duh,1,0,1.0f,4096,44100);
  module1->duhsr=al_duh_get_sigrenderer(module1->dp);
  module1->itsr=duh_get_it_sigrenderer(module1->duhsr);
  module1->playing=1;
}

void play2()
{
  module2->duh = dumb_load_mod_quick(module2->filename);
  dumb_it_do_initial_runthrough(module2->duh);
  module2->sd = duh_get_it_sigdata(module2->duh);

  module2->dp = al_start_duh(module2->duh,1,0,1.0f,4096,44100);
  module2->duhsr=al_duh_get_sigrenderer(module2->dp);
  module2->itsr=duh_get_it_sigrenderer(module2->duhsr);
  module2->playing=1;
}


void get_input()
{
  if(key[KEY_Q]) desired_speed++;
  if(key[KEY_A]) desired_speed--;
  if(key[KEY_W]) desired_tempo++;
  if(key[KEY_S]) desired_tempo--;

  if (desired_speed<1) desired_speed=1;
  if (desired_tempo<1) desired_tempo=1;

  if(key[KEY_F1] && !koff[8]) {_beginthread(open1,4096,NULL);koff[8]=1;}
  if(key[KEY_F2]) module1->play=1;
 // if(key[KEY_F3]) module1->stop=1;
  if(key[KEY_F5] && !koff[9]) {_beginthread(open2,4096,NULL);koff[9]=1;}
  if(key[KEY_F6]) module2->play=1;
 // if(key[KEY_F7]) module2->stop=1;

  if(key[KEY_1] && !koff[0]) {module1->onoff[0]^=1;koff[0]=1;}
  if(key[KEY_2] && !koff[1]) {module1->onoff[1]^=1;koff[1]=1;}
  if(key[KEY_3] && !koff[2]) {module1->onoff[2]^=1;koff[2]=1;}
  if(key[KEY_4] && !koff[3]) {module1->onoff[3]^=1;koff[3]=1;}

  if(key[KEY_5] && !koff[4]) {module2->onoff[0]^=1;koff[4]=1;}
  if(key[KEY_6] && !koff[5]) {module2->onoff[1]^=1;koff[5]=1;}
  if(key[KEY_7] && !koff[6]) {module2->onoff[2]^=1;koff[6]=1;}
  if(key[KEY_8] && !koff[7]) {module2->onoff[3]^=1;koff[7]=1;}

  if(!key[KEY_1]) koff[0]=0;
  if(!key[KEY_2]) koff[1]=0;
  if(!key[KEY_3]) koff[2]=0;
  if(!key[KEY_4]) koff[3]=0;
  if(!key[KEY_5]) koff[4]=0;
  if(!key[KEY_6]) koff[5]=0;
  if(!key[KEY_7]) koff[6]=0;
  if(!key[KEY_8]) koff[7]=0;
  if(!key[KEY_F1]) koff[8]=0;
  if(!key[KEY_F5]) koff[9]=0;


  if (mod1 && mod2) {
  if (!module1->playing && !module2->playing)
  {
    if (module1->play) play1();
    if (module2->play) play2();
  }
  }

}

void process_input()
{
   int c;
   if (!module1->playing && module1->play) play1();
   if (!module2->playing && module2->play) play2();
   if (module1->playing && module1->stop) stop1();
   if (module2->playing && module2->stop) stop2();
}

void update_current_data(MODULE *mod)
{
  int c,i,p,bsh;
    for (c=0;c<4;c++)
   {
     dumb_it_sr_set_channel_muted(module1->itsr,c,module1->onoff[c]^1);
     dumb_it_sr_set_channel_muted(module2->itsr,c,module2->onoff[c]^1);
   }
  dumb_it_sr_set_tempo(mod->itsr,desired_tempo);
  dumb_it_sr_set_speed(mod->itsr,desired_speed);
  al_poll_duh(mod->dp);
  if (current_speed!=24*dumb_it_sr_get_tempo(mod->itsr)/dumb_it_sr_get_speed(mod->itsr))
  {
    current_speed=(24*dumb_it_sr_get_tempo(mod->itsr))/dumb_it_sr_get_speed(mod->itsr);
    install_int_ex(timingproc, BPS_TO_TIMER(current_speed));
  }
  //if (dumb_it_sr_get_current_row(itsr)==0 && row>60) row-=60;
 // if (dumb_it_sr_get_current_row(itsr)==1) row=1;

  if (mod->cur_order!=dumb_it_sr_get_current_order(mod->itsr))
  {
    mod->cur_order=dumb_it_sr_get_current_order(mod->itsr);
    mod->cur_pattern=mod->order[mod->cur_order];
    if (row>=64*60) row-=64*60; else row=0;

  }
  mod->cur_row=row/60;
  memcpy(mod->cur_data,mod->pattern[mod->cur_pattern][mod->cur_row],24);
  poscent=((64.0*mod->cur_order)+dumb_it_sr_get_current_row(mod->itsr))/(64.0*(mod->n_order+1));
  if (mod->cur_row==0) process_input();
}

void timingproc()
{
sec++;row++;
}
END_OF_FUNCTION(timingproc);

int main(int argc, char *argv[])
{
    int c,psh,p,bsh,hillb;
    desired_speed=4;
    desired_tempo=140;
    allegro_init();
    install_keyboard();
    install_timer();
    install_mouse();
    dumb_register_packfiles();
    install_sound(DIGI_AUTODETECT, MIDI_NONE, argv[0]);
    srand(time(NULL));
    set_color_depth(32);
    set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0);

   page1 = create_video_bitmap(SCREEN_W, SCREEN_H);
   page2 = create_video_bitmap(SCREEN_W, SCREEN_H);

   if ((!page1) || (!page2)) {
      set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
      allegro_message("Unable to create two video memory pages\n");
      return 1;
   }
    active_page = page2;

  set_display_switch_mode(SWITCH_BACKGROUND);
  bg = load_bitmap("dark.bmp",NULL);




    LOCK_FUNCTION(timingproc);
    LOCK_VARIABLE(sec);
    LOCK_VARIABLE(div);
  // textout_centre_ex(active_page, font, "press space", SCREEN_W/2, SCREEN_H/2, makecol(255,255,255), -1);
 //  while(!key[KEY_SPACE]);

   while(!key[KEY_ESC])
   {
       clear_to_color(active_page, makecol(0,0,0));
       blit(bg,active_page,0,0,0,0,640,480);
      get_input();
      if (mod1 && module1->playing) update_current_data(module1);
      if (mod2 && module2->playing) update_current_data(module2);
      draw();

/*
      textprintf_centre_ex(active_page, font, SCREEN_W / 2, 120,makecol(0, 0, 0), -1,"poscent:%f",poscent);
      textout_centre_ex(active_page, font, tmp2, SCREEN_W/2, SCREEN_H/2, makecol(0,0,0), -1);
      textout_centre_ex(active_page, font, tmp, SCREEN_W/2, SCREEN_H/2+20, makecol(0,0,0), -1);
     // textout_centre_ex(active_page, font, "Hello, world!", SCREEN_W/2, SCREEN_H/2, makecol(0,0,0), -1);
  */
      show_video_bitmap(active_page);

      if (active_page == page1) active_page = page2; else active_page = page1;
   }



    remove_timer();
    remove_sound();
    dumb_exit();
    allegro_exit();
    return 0;
}
END_OF_MAIN();

