/*
 * Road Raid (?) 0.3
 * Engine : Charnooh
 * Physics: Monstrous Software
 * Copyright (c) 2004 Monstrous Software && Charnooh
 */

#include <stdio.h>
#include <math.h>
#include <string.h>
#include "allegro.h"
#include "alleggl.h"
//#include <glut.h>
extern void spcPlay(const char*);
extern void spcStop();

/* Defines
 */
#define TRAIL_SIZE		200			/* number of dots in car trail */
#define DELTA_T			0.01		/* time between integration steps in physics modelling */
#define	INPUT_DELTA_T	0.1			/* delay between keyboard polls */

#ifndef M_PI						/* if not in math.h, i.e. MSVC */
# define M_PI 3.1415926
#endif


/* Typedefs
 */


typedef struct VEC2
{
	float 	x,y;
} VEC2;


typedef struct CARTYPE
{
	float	wheelbase;		// wheelbase in m
	float	b;				// in m, distance from CG to front axle
	float	c;				// in m, idem to rear axle
	float	h;				// in m, height of CM from ground
	float	mass;			// in kg
	float	inertia;		// in kg.m
	float	length,width;
	float	wheellength,wheelwidth;
} CARTYPE;

typedef struct CAR
{
	CARTYPE	*cartype;			// pointer to static car data
	
	VEC2	position_wc;		// position of car centre in world coordinates
	VEC2	velocity_wc;		// velocity vector of car in world coordinates

	float	angle;				// angle of car body orientation (in rads)
	float	angularvelocity;

	float	steerangle;			// angle of steering (input)
	float	throttle;			// amount of throttle (input)
	float	brake;				// amount of braking (input)
} CAR;

typedef struct TRAILPOINT
{
	float	x,y;
	float	angle;
} TRAILPOINT;

/* Globals
 */

CARTYPE			cartypes[1];
VEC2			screen_pos;
float			scale;
char			str[80];
volatile int 	ticks = 1;			// ticks of DELTA_T second
volatile int 	iticks = 1;			// ticks of INPUT_DELTA_T second
TRAILPOINT		trail[ TRAIL_SIZE ];
int				num_trail = 0;
BITMAP *mybmp,*hud;
GLuint mytex,tex2,huud;
FONT *agl_font;
float DRAG,RESISTANCE,CA_R,CA_F,MAX_GRIP;
/* Lots of globals, so their value may be printed on screen
 * normally most of these variables should be private to the physics function.
 */
	VEC2	velocity;
	VEC2	acceleration_wc;
	double	rot_angle;
	double	sideslip;
	double	slipanglefront;
	double	slipanglerear;
	VEC2	force;
	int		rear_slip;
	int		front_slip;
	VEC2	resistance;
	VEC2	acceleration;
	double	torque;
	double	angular_acceleration;
	double	sn, cs;
	double	yawspeed;
	double	weight;
	VEC2	ftraction;
	VEC2	flatf, flatr;

/* Functions
 */

void ticks_timer( void )
{
	ticks++;
}
END_OF_FUNCTION(ticks_timer);



void iticks_timer( void )
{
	iticks++;
}
END_OF_FUNCTION(iticks_timer);


/*
 * Trail module
 */


void init_trail( void )
{
		num_trail = 0;
};


void draw_trail( BITMAP *buffer, CAR *car )
{
	int		col;
	int		i;
	int		x,y;

	col = makecol(230,230,230);

	for(i = 0; i < num_trail; i++)
	{
		x =  (trail[i].x-car->position_wc.x)*scale+screen_pos.x;
		y = -(trail[i].y-car->position_wc.y)*scale+screen_pos.y;
		circle(buffer, x, y, 2, col);
	}
}

void add_to_trail( float x, float y, float angle)
{

	if( num_trail < TRAIL_SIZE-1 )
	{
		trail[num_trail].x = x;
		trail[num_trail].y = y;
		trail[num_trail].angle = angle;
		num_trail++;
	}
	else
	{
		memcpy( trail+0, trail+1, sizeof(trail[0])*(TRAIL_SIZE-1));
		trail[num_trail].x = x;
		trail[num_trail].y = y;
		trail[num_trail].angle = angle;
	}
}


/*
 * End of Trail module
 */

/*
 * Render module
 */

void draw_rect( BITMAP *buffer, float angle, int w, int l, int x, int y, int col, int crossed)
{
	VEC2	c[4];
	VEC2	c2[4];
	float	sn, cs;
	int		i;

    sn = sin(angle);
    cs = cos(angle);

    c[0].x = -w/2;
    c[0].y = l/2;

    c[1].x = w/2;
    c[1].y = l/2;

    c[2].x = w/2;
    c[2].y = -l/2;

    c[3].x = -w/2;
    c[3].y = -l/2;

	for(i = 0; i <= 3; i++)
	{
		c2[i].x = cs*c[i].x - sn*c[i].y;
		c2[i].y = sn*c[i].x + cs*c[i].y;
		c[i].x = c2[i].x;
		c[i].y = c2[i].y;
	}

	for(i = 0; i <= 3; i++)
	{
		c[i].x += x;
		c[i].y += y;
	}
	line(buffer, c[0].x, c[0].y, c[1].x, c[1].y, col);
	line(buffer, c[1].x, c[1].y, c[2].x, c[2].y, col);
	line(buffer, c[2].x, c[2].y, c[3].x, c[3].y, col);
	line(buffer, c[3].x, c[3].y, c[0].x, c[0].y, col);

	if(crossed)
	{
		line(buffer, c[0].x, c[0].y, c[2].x, c[2].y, col);
		line(buffer, c[1].x, c[1].y, c[3].x, c[3].y, col);
	}
}


void draw_wheel( int nr, BITMAP *buffer, CAR *car, int x, int y, int crossed)
{
	int		col;

	col = makecol(0,160,0);

	draw_rect(buffer, car->angle+(nr<2 ? car->steerangle : 0),
		car->cartype->wheelwidth*scale, car->cartype->wheellength*scale, x, y, col, crossed );
}

void render(CAR *car)
{
//	int		col;
//	VEC2	corners[4];
//	VEC2	wheels[4];
//	VEC2	w[4];
	float	sn, cs;
//	int		i;
//	int		y;

	sn = sin(car->angle);
	cs = cos(car->angle);

	screen_pos.x =  car->position_wc.x;
	screen_pos.y = -car->position_wc.y;
 
     allegro_gl_begin(); 
      glMatrixMode (GL_PROJECTION); 
      glLoadIdentity (); 
     glPushMatrix();
         glFrustum (-1.0, 1.0, -1.0, 1.0, 1.0, 500.0); 
   //   glMatrixMode (GL_MODELVIEW); 
   //   glLoadIdentity();
      glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
      // allegro_gl_printf(agl_font, 0,6,0.1, makecol(255, 255, 255), "camera x: %lf",camera.xdist);
    //  glRotatef (camera.xangle, 1, 0, 0);
   
     
       glRotatef (-1*(car->angle*180)/M_PI, 0, 1, 0); 
    //  glRotatef (camera.zangle, 0, 0, 1); 
      glTranslatef (car->position_wc.x, -1.0, car->position_wc.y); 

      glEnable(GL_BLEND);
      glDisable(GL_FOG);
      glBindTexture(GL_TEXTURE_2D, mytex);
      glBegin(GL_QUADS); 
        glTexCoord2f(1, 0); glVertex3d(-20, 0, -500); 
        glTexCoord2f(1, 1); glVertex3d(20, 0, -500); 
        glTexCoord2f(0, 1); glVertex3d(20, 0, 0); 
        glTexCoord2f(0, 0); glVertex3d(-20, 0, 0); 
        
        glTexCoord2f(1, 0); glVertex3d(-20, 0, -1000); 
        glTexCoord2f(1, 1); glVertex3d(20, 0, -1000); 
        glTexCoord2f(0, 1); glVertex3d(20, 0, -500); 
        glTexCoord2f(0, 0); glVertex3d(-20, 0, -500); 
        
        glTexCoord2f(1, 0); glVertex3d(-20, 0, -1500); 
        glTexCoord2f(1, 1); glVertex3d(20, 0, -1500); 
        glTexCoord2f(0, 1); glVertex3d(20, 0, -1000); 
        glTexCoord2f(0, 0); glVertex3d(-20, 0, -1000); 
        
        glTexCoord2f(1, 0); glVertex3d(-20, 0, -2000); 
        glTexCoord2f(1, 1); glVertex3d(20, 0, -2000); 
        glTexCoord2f(0, 1); glVertex3d(20, 0, -1500); 
        glTexCoord2f(0, 0); glVertex3d(-20, 0, -1500); 
      glEnd(); 
      glBindTexture(GL_TEXTURE_2D, tex2);      
      glBegin(GL_QUADS); 
        glTexCoord2f(1, 0); glVertex3d(-23, 2, -500); 
        glTexCoord2f(1, 1); glVertex3d(-20, 0, -500); 
        glTexCoord2f(0, 1); glVertex3d(-20, 0, 0); 
        glTexCoord2f(0, 0); glVertex3d(-23, 2, 0); 
        
        glTexCoord2f(1, 0); glVertex3d(20, 0, -500); 
        glTexCoord2f(1, 1); glVertex3d(23, 2, -500); 
        glTexCoord2f(0, 1); glVertex3d(23, 2, 0); 
        glTexCoord2f(0, 0); glVertex3d(20, 0, 0); 
        
        glTexCoord2f(1, 0); glVertex3d(-23, 2, -1000); 
        glTexCoord2f(1, 1); glVertex3d(-20, 0, -1000); 
        glTexCoord2f(0, 1); glVertex3d(-20, 0, -500); 
        glTexCoord2f(0, 0); glVertex3d(-23, 2, -500); 
        
        glTexCoord2f(1, 0); glVertex3d(20, 0, -1000); 
        glTexCoord2f(1, 1); glVertex3d(23, 2, -1000); 
        glTexCoord2f(0, 1); glVertex3d(23, 2, -500); 
        glTexCoord2f(0, 0); glVertex3d(20, 0, -500); 
        
        glTexCoord2f(1, 0); glVertex3d(-23, 2, -1500); 
        glTexCoord2f(1, 1); glVertex3d(-20, 0, -1500); 
        glTexCoord2f(0, 1); glVertex3d(-20, 0, -1000); 
        glTexCoord2f(0, 0); glVertex3d(-23, 2, -1000); 
        
        glTexCoord2f(1, 0); glVertex3d(20, 0, -1500); 
        glTexCoord2f(1, 1); glVertex3d(23, 2, -1500); 
        glTexCoord2f(0, 1); glVertex3d(23, 2, -1000); 
        glTexCoord2f(0, 0); glVertex3d(20, 0, -1000); 
        
        glTexCoord2f(1, 0); glVertex3d(-23, 2, -2000); 
        glTexCoord2f(1, 1); glVertex3d(-20, 0, -2000); 
        glTexCoord2f(0, 1); glVertex3d(-20, 0, -1500); 
        glTexCoord2f(0, 0); glVertex3d(-23, 2, -1500); 
        
        glTexCoord2f(1, 0); glVertex3d(20, 0, -2000); 
        glTexCoord2f(1, 1); glVertex3d(23, 2, -2000); 
        glTexCoord2f(0, 1); glVertex3d(23, 2, -1500); 
        glTexCoord2f(0, 0); glVertex3d(20, 0, -1500); 
      glEnd();
      
      glBegin(GL_QUADS); 
        glTexCoord2f(1, 0); glVertex3d(-20, 0, 0); 
        glTexCoord2f(1, 1); glVertex3d(-23, 2, 0); 
        glTexCoord2f(0, 1); glVertex3d(23, 2, 0); 
        glTexCoord2f(0, 0); glVertex3d(20, 0, 0); 
        
        glTexCoord2f(1, 0); glVertex3d(-20, 0, 2000); 
        glTexCoord2f(1, 1); glVertex3d(-23, 2, 2000); 
        glTexCoord2f(0, 1); glVertex3d(23, 2, 2000); 
        glTexCoord2f(0, 0); glVertex3d(20, 0, 2000); 
      glEnd();
      glPopMatrix();
      
  /*    glBindTexture(GL_TEXTURE_2D,huud);
      glBegin(GL_QUADS); 
        glTexCoord2f(1, 0); glVertex2d(0, 0); 
        glTexCoord2f(1, 1); glVertex2d(.2, 0); 
        glTexCoord2f(0, 1); glVertex2d(.2, .2); 
        glTexCoord2f(0, 0); glVertex2d(0, .2); 
      glEnd();*/
      allegro_gl_flip(); 
    allegro_gl_end(); 
}


// Go into graphics mode
//
int	set_video( void )
{
  allegro_gl_clear_settings(); 
  allegro_gl_set (AGL_COLOR_DEPTH, 16); 
  allegro_gl_set (AGL_Z_DEPTH, 8); 
  allegro_gl_set (AGL_FULLSCREEN, TRUE); 
  allegro_gl_set (AGL_DOUBLEBUFFER, 1);
  allegro_gl_set (AGL_SUGGEST, AGL_COLOR_DEPTH | AGL_Z_DEPTH | AGL_DOUBLEBUFFER | AGL_FULLSCREEN);
  
  set_color_depth (16);
  if (set_gfx_mode(GFX_OPENGL, 640, 480, 0, 0) < 0){
    allegro_message ("Error durante el establecimiento del modo grafico:\n%s\n", allegro_error); 
    return -1;  
  } 
//  load_mesh("a.raw");
//  merc=mec;
//  text_mode(-1);
  
  mybmp=load_bmp("lep.bmp",NULL);
  allegro_gl_use_mipmapping(TRUE);
  allegro_gl_set_texture_format(GL_RGB8);
  mytex = allegro_gl_make_texture(mybmp);
  glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER,GL_LINEAR); 
  glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_LINEAR ); 
  mybmp=load_bmp("emblem.bmp",NULL);
  tex2 = allegro_gl_make_texture(mybmp);
  glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER,GL_LINEAR); 
  glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_LINEAR );   
  
  hud=create_bitmap(640,480);
  
  //clear_bitmap(hud);
  clear_to_color(hud,makecol(0,0,0));
  textprintf(hud,font,0,0,makecol(255,255,255),"last:");
//  glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER,GL_LINEAR); 
//  glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_LINEAR );   
  huud = allegro_gl_make_texture(hud);
  
  agl_font = allegro_gl_convert_allegro_font(font, AGL_FONT_TYPE_TEXTURED, 16.0);
  
  allegro_gl_begin(); 
    glClearColor(0.5f, 0.5f, 1.0f, 1.0f);
    glShadeModel (GL_SMOOTH); 
    glPolygonMode (GL_FRONT, GL_FILL); 
    glEnable (GL_DEPTH_TEST); 
    glEnable(GL_POLYGON_SMOOTH);
    glEnable(GL_TEXTURE_2D);
    glEnable(GL_FOG);
    glFogf(GL_FOG_MODE,GL_EXP);
    glFogf(GL_FOG_DENSITY,.003);
    glFogf(GL_FOG_START  ,.1);
    glFogf(GL_FOG_END    ,500.0);
    glFogi(GL_FOG_COLOR  ,makecol(255,255,255));
    glEnable(GL_BLEND);
    glHint(GL_FOG_HINT, GL_DONT_CARE);
    glHint(GL_POLYGON_SMOOTH_HINT, GL_NICEST);
    glHint(GL_PERSPECTIVE_CORRECTION_HINT,GL_NICEST);
  allegro_gl_end(); 
  return 0;
}


// take_screen_shot - Dump current screen contents to a file
//
void take_screen_shot( void )
{
	BITMAP		*buf;
	PALETTE 	pal;
	int			ok;
	FILE		*fp;
	int			counter;
	char		filename[20];
//	static char	msg[40];

	buf = create_bitmap(SCREEN_W, SCREEN_H);
	get_palette( pal );

	acquire_screen();
	blit(screen, buf, 0, 0, 0,0, buf->w, buf->h);
	release_screen();

	counter = 1;

	do
	{
		sprintf(filename, "screen%02d.bmp", counter);		// screen01.bmp, screen02.bmp, etc
		fp = fopen(filename, "r");
		if( fp != NULL )
		{
			// file already exists, close it and try next number
			fclose(fp);
			counter++;
		}

	} while (fp != NULL);
	// we now have a filename that doesn't yet exist


	ok= save_bitmap( filename, buf, pal);
	destroy_bitmap( buf );
	return;
}



/*
 * End of Render module
 */

/*
 * Physics module
 */
void init_cartypes( void )
{
	CARTYPE	*cartype;

	cartype = &cartypes[0];
	cartype->b = 1.0;					// m							
	cartype->c = 1.0;					// m
	cartype->wheelbase = cartype->b + cartype->c;
	cartype->h = 1.0;					// m
	cartype->mass = 1500;				// kg			
	cartype->inertia = 1500;			// kg.m			
	cartype->width = 1.5;				// m
	cartype->length = 3.0;				// m, must be > wheelbase
	cartype->wheellength = 0.7;
	cartype->wheelwidth = 0.3;
}

void init_car( CAR *car, CARTYPE *cartype )
{
	car->cartype = cartype;
	
	car->position_wc.x = 0;
	car->position_wc.y = -25;
	car->velocity_wc.x = 0;
	car->velocity_wc.y = 0;

	car->angle = 0;
	car->angularvelocity = 0;

	car->steerangle = 0;
	car->throttle = 0;
	car->brake = 0;
}

// These constants are arbitrary values, not realistic ones.
void togglevel(int hard)
{
if (hard) {
DRAG		=8.0;		 		/* factor for air resistance (drag) 	*/
RESISTANCE	=50.0;			/* factor for rolling resistance */
CA_R		=-15.20;			/* cornering stiffness */
CA_F		=-15.0;			/* cornering stiffness */
MAX_GRIP	=5.0;				/* maximum (normalised) friction force, =diameter of friction circle */
} else {
DRAG		=5.0;		 		/* factor for air resistance (drag) 	*/
RESISTANCE	=30.0;			/* factor for rolling resistance */
CA_R		=-5.20;			/* cornering stiffness */
CA_F		=-5.0;			/* cornering stiffness */
MAX_GRIP	=2.0;				/* maximum (normalised) friction force, =diameter of friction circle */
}
}

void do_physics( CAR *car, float delta_t )
{
	sn = sin(car->angle);
	cs = cos(car->angle);

	// SAE convention: x is to the front of the car, y is to the right, z is down
	
	// transform velocity in world reference frame to velocity in car reference frame
	velocity.x =  cs * car->velocity_wc.y + sn * car->velocity_wc.x;
	velocity.y = -sn * car->velocity_wc.y + cs * car->velocity_wc.x;

// Lateral force on wheels
//	
	// Resulting velocity of the wheels as result of the yaw rate of the car body
	// v = yawrate * r where r is distance of wheel to CG (approx. half wheel base)
	// yawrate (ang.velocity) must be in rad/s
	//
	yawspeed = car->cartype->wheelbase * 0.1 * car->angularvelocity;	

	if( velocity.x == 0 )		// TODO: fix singularity
		rot_angle = 0;
	else
		rot_angle = atan2( yawspeed, velocity.x);

	// Calculate the side slip angle of the car (a.k.a. beta)
	if( velocity.x == 0 )		// TODO: fix singularity
		sideslip = 0;
	else
		sideslip = atan2( velocity.y, velocity.x);		

	// Calculate slip angles for front and rear wheels (a.k.a. alpha)
	slipanglefront = sideslip + rot_angle - car->steerangle;
	slipanglerear  = sideslip - rot_angle;

	// weight per axle = half car mass times 1G (=9.8m/s^2) 
	weight = car->cartype->mass * 9.8 * 0.5;	
	
	// lateral force on front wheels = (Ca * slip angle) capped to friction circle * load
	flatf.x = 0;
	flatf.y = CA_F * slipanglefront;
	flatf.y = MIN(MAX_GRIP, flatf.y);
	flatf.y = MAX(-MAX_GRIP, flatf.y);
	flatf.y *= weight;
	if(front_slip)
		flatf.y *= 0.5;

	// lateral force on rear wheels
	flatr.x = 0;
	flatr.y = CA_R * slipanglerear;
	flatr.y = MIN(MAX_GRIP, flatr.y);
	flatr.y = MAX(-MAX_GRIP, flatr.y);
	flatr.y *= weight;
	if(rear_slip)
		flatr.y *= 0.5;

	// longtitudinal force on rear wheels - very simple traction model
	ftraction.x = 100*(car->throttle - car->brake*SGN(velocity.x));	
	ftraction.y = 0;
	if(rear_slip)
		ftraction.x *= 0.5;

// Forces and torque on body
	
	// drag and rolling resistance
	resistance.x = -( RESISTANCE*velocity.x + DRAG*velocity.x*ABS(velocity.x) );
	resistance.y = -( RESISTANCE*velocity.y + DRAG*velocity.y*ABS(velocity.y) );

	// sum forces
	force.x = ftraction.x + sin(car->steerangle) * flatf.x + flatr.x + resistance.x;
	force.y = ftraction.y + cos(car->steerangle) * flatf.y + flatr.y + resistance.y;	

	// torque on body from lateral forces
	torque = car->cartype->b * flatf.y - car->cartype->c * flatr.y;

// Acceleration
	
	// Newton F = m.a, therefore a = F/m
	acceleration.x = force.x/car->cartype->mass;
	acceleration.y = force.y/car->cartype->mass;
	
	angular_acceleration = torque / car->cartype->inertia;

// Velocity and position
	
	// transform acceleration from car reference frame to world reference frame
	acceleration_wc.x =  cs * acceleration.y + sn * acceleration.x;
	acceleration_wc.y = -sn * acceleration.y + cs * acceleration.x;

	// velocity is integrated acceleration
	//
	car->velocity_wc.x += delta_t * acceleration_wc.x;
	car->velocity_wc.y += delta_t * acceleration_wc.y;

	// position is integrated velocity
	//
	car->position_wc.x += delta_t * car->velocity_wc.x;
	car->position_wc.y += delta_t * car->velocity_wc.y;


// Angular velocity and heading

	// integrate angular acceleration to get angular velocity
	//
	car->angularvelocity += delta_t * angular_acceleration;

	// integrate angular velocity to get angular orientation
	//
	car->angle += delta_t * car->angularvelocity ;
   if (car->position_wc.x> 18)  car->position_wc.x=18;
   if (car->position_wc.x< -18)  car->position_wc.x=-18;
   if (car->position_wc.y> 1500)  car->position_wc.y-=500;
  if (car->position_wc.y< 500)  car->position_wc.y+=500;
}
	
/*
 * End of Physics module
 */


/*
 * Input module
 */


int process_input(  CAR *car )
{
//	int		keycode;
	int		quit;

	quit = 0;


	// discrete keypresses
	//
/*	while( keypressed() )
	{
		keycode = readkey();
*/
		if (key[KEY_ESC] )			// Esc to Quit
		{
			quit=1;
		}

		if (key[KEY_F12])			// F12 to reset
		{
			init_car( car, &cartypes[0] );
			init_trail();
		}

     
     		if (key[KEY_F1])			// F12 to reset
		{
		  togglevel(1);
		}

 		if (key[KEY_F2])			// F12 to reset
		{
		  togglevel(0);
		}
		
	if( key[KEY_UP] )	// throttle up
	{
		if( car->throttle < 200)
			car->throttle += 2;
	}
	if( key[KEY_DOWN] ) // throttle down
	{
	if( car->throttle >= 10)
			car->throttle -= 10;
	}

	if( key[KEY_SPACE] )	// brake
	{
		car->brake = 100;
		car->throttle = 0;
	}
	else
		car->brake = 0;

	// Steering 
	//
	if( key[KEY_RIGHT] )
	{
		if( car->steerangle > - M_PI/16.0 )
			car->steerangle -= M_PI/1024.0;
	}
	else if( key[KEY_LEFT] )
	{
		if( car->steerangle <  M_PI/16.0 )
			car->steerangle += M_PI/1024.0;
	}
	else 
/*    if (car->steerangle> -M_PI/32.0 && car->steerangle<M_PI/32.0)*/ car->steerangle=0;
    
//    if (car->velocity_wc.x==0 && car->velocity_wc.y==0) car->steerangle=0;
 // Zoom in, zoom out

	// Let front, rear or both axles slip
	rear_slip = 0;
	front_slip = 0;
/*	if( key[KEY_R] )
		rear_slip = 1;
	if( key[KEY_F] )
		front_slip = 1;
	if( key[KEY_RCONTROL] )
	{
		front_slip = 1;
		rear_slip = 1;
	}*/
//	if (key[KEY_V]) init_car(&car,&cartypes[0]);
	return quit;
}

/*
 * End of Input module
 */



int main( int argc, char **argv[] )
{
//	BITMAP 		*buffer;
	int			quit;
	CAR			car;
	int			lastticks=0;
	int			lastiticks = 0;

	allegro_init ();
	install_allegro_gl();
	install_keyboard ();
	install_timer();
 //   glutInit(&argc,argv);   // This will initialize Glut.
	togglevel(1);
	set_video();

	// tick counter - incremented every DELTA_T second
	// Used to make game speed independent of frame rate
	//
	LOCK_FUNCTION(ticks_timer);
	LOCK_VARIABLE(ticks);
	install_int_ex( ticks_timer,MSEC_TO_TIMER(1));	// ms
//DELTA_T * 1000
	// itick counter - sample rate for keyboard input
	// 
	LOCK_FUNCTION(iticks_timer);
	LOCK_VARIABLE(iticks);
	install_int_ex( iticks_timer, MSEC_TO_TIMER(20));	// ms
//INPUT_DELTA_T * 1000
	//buffer = create_bitmap(SCREEN_W, SCREEN_H);

	// initial scale of rendering
	scale = 10;						// pixels per m
	
	init_cartypes();
	init_car( &car, &cartypes[0] );
	
	init_trail();
  //  spcPlay("ff6-303.spc");
	quit = 0;
	while(!quit)
	{
		render(&car);

		// Copy the memory buffer to the screen
		//
		//blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);

		// Call input function once per itick
		if( iticks != lastiticks )
		{
			lastiticks = iticks;
			// Get keyboard input
			//
			quit = process_input(&car);
		}
		
		// Call movement functions once per tick
		if( ticks != lastticks )
		{
			lastticks = ticks;

			do_physics(&car, .01);
	//		add_to_trail( car.position_wc.x, car.position_wc.y, car.angle );
		}
	}


	//destroy_bitmap(buffer);
  //  spcStop();
	remove_timer();
	allegro_exit();
	return 0;
}
END_OF_MAIN();


