#include <stdio.h>
#include <math.h>
#include <allegro.h>
#include <aldumb.h>

BITMAP *page1,*page2,*active_page,*bg;
volatile int tim;
#define W 80
#define H 60
#define BUFFER 1024
#define BULLETS 1024
#define PARTICLES 1024
#define SHOT_SPEED 3.7f
#define SPEED 4.2f
#define FRAND (((rand()%2048)/1024.0f)-1.0f)
char buffer[BUFFER][W];
char grid[H][W];


char* filename="0h13.c";
float bullets[BULLETS][3];
float particles[PARTICLES][5];
int scroll_delay=0;
int nextline=0;
int numlines=0;
int finished=0;

float px=0,py=0;
int current_bullet=0;
int current_particle=0;
int shot_delay = 0;
int gameover=0;
int winned=0;

//SAMPLE* win,*lose,*gun,*boom;
DATAFILE* snds;

int rysuj()
{
  int x,y,c;
  ////printf("R1-");
 masked_stretch_blit(bg,active_page,0,0,320,240,0,0,SCREEN_W,SCREEN_H);
 masked_stretch_blit(bg,active_page,120,0,160,120,0,0,SCREEN_W,SCREEN_H);
 masked_stretch_blit(bg,active_page,200,140,200,150,0,0,SCREEN_W,SCREEN_H);
 masked_stretch_blit(bg,active_page,0,40,80,60,0,0,SCREEN_W,SCREEN_H);
 clear_to_color(bg, makecol(255, 0, 255));
 ////printf("R1.5-");
  for(c=0;c<H;c++) // lines
  {
    x=0;
    y=c*8+scroll_delay%8;
    grid[c][W-1]=0;
    ////printf(":%02x",c);
    ////printf("%s",grid[c]);

    textout_ex(active_page,font,grid[c],x,y,makecol(0,255,0),-1);
    textout_ex(bg,font,grid[c],x,y,makecol(0,20+rand()%80,0),-1);

  }
  if (finished>H && !gameover) textprintf_centre_ex(active_page,font,SCREEN_W/2,SCREEN_H/2,makecol(0,255,0),-1,"You won!");
  if (gameover) textprintf_centre_ex(active_page,font,SCREEN_W/2,SCREEN_H/2,makecol(255,0,0),-1,"GAME OVER");
 // //printf("R2-");
  for(c=0;c<BULLETS;c++)
  {
    if (!bullets[c][0] && !bullets[c][1]) continue;
    vline(active_page,bullets[c][0],bullets[c][1]-2,bullets[c][1]+2,makecol(255,255,0));
    vline(active_page,bullets[c][0]+1,bullets[c][1]-2,bullets[c][1]+2,makecol(255,255,0));
  }
  ////printf("R3-");
   for(c=0;c<PARTICLES;c++)
  {
    if (!particles[c][0] && !particles[c][1]) continue;
    int col=particles[c][4];
    int s=col>>5;
    rectfill(active_page,particles[c][0],particles[c][1],particles[c][0]+s,particles[c][1]+s,makecol(col,255,0));
    /*
    putpixel(active_page,particles[c][0]+1,particles[c][1],makecol(col,255,col));
    putpixel(active_page,particles[c][0],particles[c][1]+1,makecol(col,255,col));
    putpixel(active_page,particles[c][0]+1,particles[c][1]+1,makecol(col,255,col));
    */

  }
  ////printf("R4-");
  textprintf_ex(active_page,font,px,py,makecol(255,255,0),-1,"@");
////printf("R5-\n");
}


int timer_proc()
{
  int c,x,y,i;
  if (finished>H)
  {

    if (!winned) play_sample(snds[0].dat,255,128,1000,0);
    winned=1;
  }
  if (shot_delay) shot_delay--;
  scroll_delay++;
  if (!(scroll_delay%8))
  {
    scroll_buffer();
  }
  if (key[KEY_LEFT]) px-=SPEED;
  if (key[KEY_RIGHT]) px+=SPEED;
  if (px<0) px=0;
  if (px>SCREEN_W) px=SCREEN_W;
  if (key[KEY_SPACE] && !shot_delay &&! gameover)
  {
    play_sample(snds[3].dat,10+rand()%20,128+SCREEN_W/2-px,800+rand()%400,0);
    bullets[current_bullet][0]=px;
    bullets[current_bullet][1]=py+FRAND*8;
    bullets[current_bullet][2]=-SHOT_SPEED*2+FRAND*SHOT_SPEED;
    //shot_delay=1;
    current_bullet++;
  //  //printf(" bullet: %i %f %f\n",current_bullet,px,py);
    if (current_bullet>=BULLETS) current_bullet=0;
  }

  for(c=0;c<BULLETS;c++)
  {
    if (!bullets[c][0] && !bullets[c][1]) continue;
    bullets[c][1]+=bullets[c][2];

    if (bullets[c][1]<-50)
    {
      bullets[c][0]=0;
      bullets[c][1]=0;
      continue;
    }
    x=bullets[c][0]/8;
    y=bullets[c][1]/8;
    if (grid[y][x] && grid[y][x]!=' ' && y<H && x<W-1  && y>=0 && x>=0)
    {
      ////printf(" SHOT [%c] at %i,%i\n",grid[y][x],x,y);
      for (i=0;i<8;i++)
      {
      float a,d;
      grid[y][x]=' ';
      particles[current_particle][0]=bullets[c][0];
      particles[current_particle][1]=bullets[c][1];

      a = (FRAND+1.0)*M_PI;
      d = (FRAND+2.0)*2.0;
      particles[current_particle][2]=cos(a)*d;
      particles[current_particle][3]=sin(a)*d;if (!gameover)
      particles[current_particle][4]=255.0f;
      current_particle++;
      //printf(" paritcle: %i %f %f\n",current_particle,px,py);
      if (current_particle>=BULLETS) current_particle=0;
      if (!gameover) play_sample(snds[2].dat,10+rand()%20,128+W/2-x,800+rand()%400,0);
      }
    }
  }

  for(c=0;c<PARTICLES;c++)
  {
    if (!particles[c][0] && !particles[c][1]) continue;
    particles[c][1]+=particles[c][3];
    particles[c][0]+=particles[c][2];

    particles[c][3]+=.3f;

    particles[c][4]*=.93f;

    if (particles[c][1]<0 || particles[c][0]<0 || particles[c][1]>SCREEN_W || particles[c][0]>SCREEN_H)
    {
      particles[c][0]=0;
      particles[c][1]=0;
      continue;
    }

  }
}

int scroll_buffer()
{
  int x,y;
  ////printf("Scrolling!\n");
  //printf(" - next line: %i\n",numlines);
  for (x=0;x<W;x++)
  {
    if (!grid[H-1][x]) continue;
    if (grid[H-1][x]<=32) continue;
    if (grid[H-1][x]>=127) continue;

    if (!gameover) play_sample(snds[1].dat,255,128,200,0);
    gameover++;

    break;
  }
  for (y=H-1;y>0;y--)
  {
    memset(grid[y],0,W);
    memcpy(grid[y],grid[y-1],W);
  }

  if (numlines) memcpy(grid[0],buffer[--numlines],W); else  {memset(grid[0],0,W);finished++;}
}

int fill_buffer()
{
  int c,y;
  //printf("Filling up buffer!\n");
  for (y=0;y<H;y++)
  {
    memcpy(grid[y],buffer[--numlines],W);
  }
}

int init()
{
  int x=0,y=0;
  char c;
  //printf("Loading source...\n");
  FILE *f = fopen(filename,"r");
  if (!f) exit(-1);
   memset(buffer,0,BUFFER*W);
   memset(grid,0,H*W);
   memset(bullets,0,BULLETS*2*sizeof(float));
   memset(particles,0,PARTICLES*4*sizeof(float));
  do {
    c = fgetc(f);
    if (c=='\r') continue;
    if (c=='\n') goto linefeed;
    buffer[y][x] = c;
    //printf("%c",c);
    x++;
    if (x>=W-1)
    {
      while (fgetc(f)!='\n' && !feof(f));
linefeed:
      x=0;
      y++;
      numlines++;
      if (y>BUFFER) break;
    }
  } while (!feof(f));
  fclose(f);
  //printf("Loaded %i lines!\n",numlines);
  //printf("Done!\n");
}

void timer()
{
	tim++;
}
END_OF_FUNCTION(timer);

  DUH *duh;          /* Encapsulates the music file. */
	AL_DUH_PLAYER *dp; /* Holds the current playback state. */
	DUMB_IT_SIGDATA *sd;
	DUH_SIGRENDERER *duhsr;
	DUMB_IT_SIGRENDERER *itsr;

int main(int argc, char *argv[])
{
    char a=1;
    do a++; while(a);
  if(argc>1) filename=argv[1];
	allegro_init();
	dumb_register_packfiles();
    install_keyboard();
    install_timer();
 //   install_mouse();
    install_sound(DIGI_AUTODETECT, MIDI_NONE, argv[0]);
    srand(time(NULL));
        set_color_depth(32);
    set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0);


   page1 = create_video_bitmap(SCREEN_W, SCREEN_H);
   page2 = create_video_bitmap(SCREEN_W, SCREEN_H);
   bg = create_bitmap(SCREEN_W, SCREEN_H);

   if ((!page1) || (!page2)) {
      set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
      allegro_message("Unable to create two video memory pages\n");
      return 1;
   }

/*
  win=load_wav("win.wav");
  lose=load_wav("jump.wav");
  gun=load_wav("gun.wav");
  boom=load_wav("boom.wav");
  */

  snds = load_datafile("sounds.dat");


    install_int_ex(timer, BPS_TO_TIMER(60));
    LOCK_FUNCTION(timer);
    LOCK_VARIABLE(tim);

    active_page = page2;

    px=SCREEN_W/2;
    py=SCREEN_H-20;


//printf("!");

    duh = dumb_load_mod_quick("compulove.mod");
    //printf("! %08x",duh);
  dumb_it_do_initial_runthrough(duh);
  //printf("!");
  sd = duh_get_it_sigdata(duh);
//printf("!");
  dp = al_start_duh(duh,1,0,1.0f,4096,22050);
  //printf("!");
  duhsr=al_duh_get_sigrenderer(dp);
  //printf("!");
  itsr=duh_get_it_sigrenderer(duhsr);
  //printf("!");

restart:
init();
    while(!key[KEY_ESC])
    {
      clear_to_color(active_page, makecol(0, 0, 0));




      while (tim >0)
      {
	      timer_proc();
	      tim--;
  	  }

      rysuj();

      show_video_bitmap(active_page);

      if (active_page == page1)
	 	active_page = page2;
      else
	 	active_page = page1;

        vsync();
        al_poll_duh(dp);
       // if (gameover>300) goto restart;
   }



    remove_timer();
    remove_sound();
    allegro_exit();
    return 0;
}
END_OF_MAIN();


