#ifdef linux

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/mman.h>
#include <linux/videodev2.h>
#include "libv4l2.h"

#endif
#include <allegro.h>
#ifdef _WIN32
#include <winalleg.h>
#include <cv.h>
#include <highgui.h>
#endif



#include <math.h>
/*
#ifdef linux
#include <alogg/alogg.h>
#elseif defined(_WIN32)
#include <alogg.h>
#endif
*/

#include "fmod.h"
FSOUND_STREAM* handle;
/// debug controls

#define DEBUGMODE 0
#define FASTMODE 0
#define DEBUGTEXT 0
#define STARTINGLEVEL 1
#define MOUSEDRIVEN 0
#define FULLSCREEN 1


#define SIZEX 640
#define SIZEY 80
#define TEXTX 160
#define TEXTY 20
#define SPRITEX 256
#define SPRITEY 256
#define SPRITEFRAMES 8
#define NUMPARTICLES 18
#define NUMQUOTES 32
#define NUMLIGHTS 32
#define BLOCK_SIZE 40960
#define NUMSPRITES 32
#define LEVELS 6
//#define ABS(x)   ((x) >= 0 ? (x) : -(x))

#define NEAR 1
#define LOOP 2
#define MOVE 3
#define SHY  4
#define DROP 5
#define FLYING 6
#define NEARONCE 7
#define FLYINGBUG 8
#define CONNECTED 9
#define STEPWALK 10
#define WINDED 11
#define TRIGGERONCE 12



typedef struct HDR
{
  unsigned char image[SIZEX][SIZEY][4];
  float normal[SIZEX][SIZEY][2];
  unsigned char lum[SIZEX][SIZEY];
  unsigned int w,h;
  BITMAP *render;
} HDR;

typedef struct HDSPRITE
{
  unsigned char image[SPRITEX*SPRITEFRAMES][SPRITEY][4];
  float normal[SPRITEX*SPRITEFRAMES][SPRITEY][2];
  unsigned char lum[SPRITEX*SPRITEFRAMES][SPRITEY];
  int w,h,x,y,current_frame,originalx,originaly;
  int mode,parameter,plain,delay,numframes;
  float framerate,fframe;
  BITMAP *render,*plainrender;
} HDSPRITE;


typedef struct HDTEXT
{
  float normal[TEXTX][TEXTY][2];
  unsigned char lum[TEXTX][TEXTY];
  int duration,fadein,fadeout,maxduration;
  unsigned char r,g,b;
  float light,textintensity,textparameter,lightx,lightspeed;
  BITMAP *render,*bump;
} HDTEXT;

typedef struct HDLIGHT
{
  int x,y,lit;
  float sine,phase,wave,light,range,theta,d,dx,dy;
} HDLIGHT;

BITMAP *page1,*page2,*active_page,*trash,*webcam;
int fx,fy,mx,my,frange,flap,tt,fstamina = 100,fregen,scroll,current_level = STARTINGLEVEL;
int gameover = 0, particles[NUMPARTICLES][5],sparks[NUMPARTICLES][5],ret,quotes[NUMQUOTES];
int sprites_amount,theend=0,capturenow,candlesize,fps,light_amount,mouse_driven = MOUSEDRIVEN;
int sprite_connections[NUMSPRITES][4],sprite_connections_count,warpblocks[4][6], fade=0;
float fintensity = 4.0,fwave,fsine,flx = 31.0,fly = 87.0,fmx,fmy,fspeed,fworn=1.0;
float highlight,lowlight,fparameter,fvx,fvy,fvd,fcandle;
float wind;
volatile int tim;
HDR *level;
HDTEXT *header,*footer;
HDSPRITE *sprites[NUMSPRITES];
HDLIGHT lights[NUMLIGHTS];
SAMPLE *glass;
struct alogg_stream *stream;
int voice;
long int playtime;
FONT *letters;
unsigned char campixels[160][120],sensitivity = 200;

#define CLEAR(x) memset(&(x), 0, sizeof(x))

#ifdef _WIN32
    CvCapture* capture;
    IplImage *frame;
#endif

#ifdef linux

struct cambuf {
	unsigned char   *start;
	size_t length;
};


	struct v4l2_format		fmt;
	struct v4l2_buffer		buf;
	struct v4l2_requestbuffers	req;
	struct v4l2_ext_control ctl;
	struct v4l2_streamparm parm;
	enum v4l2_buf_type		type;
	fd_set				fds;
	struct timeval			tv;
	int				r, fd = -1;
	unsigned int			n_buffers;
	char				*dev_name = "/dev/video0";
	char				out_name[256];
	FILE				*fout;
	struct cambuf			*buffers;



static void xioctl(int fh, int request, void *arg)
{
	int r;

	do {
		r = v4l2_ioctl(fh, request, arg);
	} while (r == -1 && ((errno == EINTR) || (errno == EAGAIN)));

	if (r == -1) {
		fprintf(stderr, "error %d, %s\n", errno, strerror(errno));
		exit(EXIT_FAILURE);
	}
}

#endif

void cross(unsigned char a, unsigned char b,unsigned char c, float *out)
{
  float aa,bb,x,y,z,angle;
  aa = (a-c)/200.0;
  bb = (b-c)/200.0;
  x = aa * sqrt(ABS(1-(bb*bb))) - 0 * bb;
  y = 0 * 0 - sqrt(ABS(1-(aa*aa))) * sqrt(ABS(1-(bb*bb)));
  z = sqrt(ABS(1-(aa*aa))) * bb - aa * 0;
  angle = atan2(x,z);
  out[0]=x;
  out[1]=z;
  //return angle;
}



HDR *load_hd(const char *bitmap, const char *bumpmap)
{
  int x,y,ax,by,aa,bb,u,col;
  unsigned char a,b,c;
  float al,bl;
  BITMAP *bittmp,*bumptmp;
  HDR *hdr;
  hdr = malloc(sizeof(HDR));

    bumptmp = load_bmp(bumpmap,NULL);
  bittmp = load_bmp(bitmap,NULL);

  for (x=0;x<bittmp->w;x++)
  {
    for (y=0;y<bittmp->h;y++)
    {
      col = getpixel(bittmp,x,y);

      hdr->image[x][y][0]=getr(col);
      hdr->image[x][y][1]=getg(col);
      hdr->image[x][y][2]=getb(col);
      col = getpixel(bumptmp,x,y);
    //  printf("%i\t",c);
      hdr->image[x][y][3]=getr(col);
    }
  }

  for (x=0;x<bumptmp->w-1;x++)
  {

    for (y=0;y<bumptmp->h-1;y++)
    {

   //   al=0.0;bl=0.0;ax=1;by=1;
      a=hdr->image[x+1][y][3];
      b=hdr->image[x][y+1][3];
      c=hdr->image[x][y][3];
      cross(a,b,c,hdr->normal[x][y]);
    }
  }

  hdr->w=bittmp->w;
  hdr->h=bittmp->h;
  hdr->render = create_bitmap(hdr->w,hdr->h);
  return hdr;
}



void render_hdr(HDR *hdr)
{
  unsigned char r,g,b,l;
  int x,y,c;
  float a,theta,fr,fg,fb,d,ffx,ffy;
  for (x=scroll;x<scroll+159;x++)
  {

    for (y=0;y<hdr->h-1;y++)
    {
      ffx=(mx-x)*1.0;
      ffy=(my-y)*1.0;
      d=sqrt(ffx*ffx+ffy*ffy);
      ffx/=d;ffy/=d;
      theta= (ffx*hdr->normal[x][y][0] + ffy*hdr->normal[x][y][1]);

    //  if(sqrt(hdr->normal[x][y][0]*hdr->normal[x][y][0] + hdr->normal[x][y][1]*hdr->normal[x][y][1])<.01) theta=.8;
    //  a=atan2((fx-x)*1.0,(fy-y)*1.0);
   //   theta=cos(hdr->normal[x][y]-a);
      theta*=-1;
      if (d) theta*=(12/d)*fintensity;
    //  if(sqrt(hdr->normal[x][y][0]*hdr->normal[x][y][0] + hdr->normal[x][y][1]*hdr->normal[x][y][1])<.01) theta/=(fintensity);
      theta-=1;
       if (theta<0.0) theta=0.0;
      if (theta>1.0) theta=1.0;

      //theta*=255;
    //  printf("%f\n",theta);

      for (c=0;c<NUMLIGHTS;c++)
      {
        if (lights[c].lit)
        {
          lights[c].dx=lights[c].x-(x*1.0);
          if (lights[c].dx<80.0)
          {
          lights[c].dy=lights[c].y-(y*1.0);
          lights[c].d=sqrt(lights[c].dx*lights[c].dx+lights[c].dy*lights[c].dy);
          lights[c].dx/=lights[c].d;
          lights[c].dy/=lights[c].d;
          lights[c].theta=(lights[c].dx*hdr->normal[x][y][0] + lights[c].dy*hdr->normal[x][y][1]);
          lights[c].theta*=-1;
          if (lights[c].d) lights[c].theta*=(12/lights[c].d)*lights[c].sine;
          lights[c].theta-=1;
          if (lights[c].theta<0.0) lights[c].theta=0.0;
          if (lights[c].theta>1.0) lights[c].theta=1.0;
          theta+=lights[c].theta;
          }
        }
      }
      if (theta<0.0) theta=0.0;
      if (theta>1.0) theta=1.0;
      l=theta;
      hdr->lum[x][y] = l;
      fr=hdr->image[x][y][0]/255.0;
      fg=hdr->image[x][y][1]/255.0;
      fb=hdr->image[x][y][2]/255.0;
      fr*=theta;fg*=theta;fb*=theta;
      fr*=255.0;fg*=255.0;fb*=255.0;
      if (fr>255,0) fr=255.0;
      if (fg>255,0) fg=255.0;
      if (fb>255,0) fb=255.0;
      r=fr;g=fg;b=fb;

      if(!hdr->image[x][y][3])
        putpixel(hdr->render,x,y,makecol(255,0,255));
      else
          putpixel(hdr->render,x,y,makecol(r,g,b));

    }

  }
}

HDSPRITE *load_hd_sprite(const char *bitmap, const char *bumpmap, int xx, int yy, int mode,float rate,int parameter,int plain,int numframes)
{
  int x,y,ax,by,aa,bb,u,col;
  unsigned char a,b,c;
  float al,bl;
  BITMAP *bittmp,*bumptmp;
  HDSPRITE *hds;
  hds = malloc(sizeof(HDSPRITE));
    bumptmp = load_bmp(bumpmap,NULL);
  bittmp = load_bmp(bitmap,NULL);
  for (x=0;x<bittmp->w;x++)
  {
    for (y=0;y<bittmp->h;y++)
    {
      col = getpixel(bittmp,x,y);
    //  printf("%8X\t",col);
      hds->image[x][y][0]=getr(col);
      hds->image[x][y][1]=getg(col);
      hds->image[x][y][2]=getb(col);
      col = getpixel(bumptmp,x,y);
   //   printf("%i\t",c);
      hds->image[x][y][3]=getr(col);
    }
  }
 // while(!key[KEY_R]);
  for (x=0;x<bumptmp->w-1;x++)
  {

    for (y=0;y<bumptmp->h-1;y++)
    {

   //   al=0.0;bl=0.0;ax=1;by=1;
      a=hds->image[x+1][y][3];
      b=hds->image[x][y+1][3];
      c=hds->image[x][y][3];
      cross(a,b,c,hds->normal[x][y]);
    }
  }

  if (plain) hds->plainrender=load_bmp(bitmap,NULL);
  hds->numframes=numframes;
  hds->w=bittmp->w/hds->numframes;
  hds->h=bittmp->h;
  hds->render = create_bitmap(hds->w,hds->h);
  hds->x=xx;
  hds->y=yy;
  hds->originalx=hds->x;
  hds->originaly=hds->y;
  hds->mode=mode;
  hds->framerate=rate;
  hds->plain=plain;
  hds->parameter=parameter;
  //destroy_bitmap(bittmp);
  //destroy_bitmap(bumptmp);

  return hds;
}

void reset_hd_sprite(HDSPRITE *hds)
{
  hds->x=hds->originalx;
  hds->y=hds->originaly;
  printf("\n[%i %i][%i %i]\n",hds->x,hds->y,hds->originalx,hds->originaly);
  hds->current_frame=0;
  hds->fframe=0.0;
  hds->delay=0;
}

void render_hd_sprite(HDSPRITE *hds)
{
  unsigned char r,g,b,l;
  int x,y,fix,fiy;
  float a,theta,fr,fg,fb,d,ffx,ffy;
  for (x=hds->w*hds->current_frame;x<hds->w*(hds->current_frame+1);x++)
  {

    for (y=0;y<hds->h;y++)
    {
      fix=(mx-(x+hds->x-(hds->current_frame*hds->w)));
      fiy=(my-(y+hds->y));
      ffx=fix;ffy=fiy;
      if (key[KEY_A]) printf("[%i,%i] ",(fx-(x+hds->x-(hds->current_frame*hds->w))),(fy-(y+hds->y)));
      d=sqrt(ffx*ffx+ffy*ffy);
      ffx/=d;ffy/=d;
      theta= (ffx*hds->normal[x][y][0] + ffy*hds->normal[x][y][1]);
    //  if(sqrt(hdr->normal[x][y][0]*hdr->normal[x][y][0] + hdr->normal[x][y][1]*hdr->normal[x][y][1])<.01) theta=.8;
    //  a=atan2((fx-x)*1.0,(fy-y)*1.0);
   //   theta=cos(hdr->normal[x][y]-a);
 //  if (key[KEY_A]) printf("%f ",theta);
    theta*=-1;
      if (d) theta*=(12/d)*fintensity;
    //  if(sqrt(hdr->normal[x][y][0]*hdr->normal[x][y][0] + hdr->normal[x][y][1]*hdr->normal[x][y][1])<.01) theta/=(fintensity);
      theta-=1;
       if (theta<0.0) theta=0.0;
      if (theta>1.0) theta=1.0;

      //theta*=255;
    //  printf("%f\n",theta);
      l=theta;
      hds->lum[x][y] = l;
      fr=hds->image[x][y][0]/255.0;
      fg=hds->image[x][y][1]/255.0;
      fb=hds->image[x][y][2]/255.0;
      fr*=theta;fg*=theta;fb*=theta;
      fr*=255.0;fg*=255.0;fb*=255.0;
      if (fr>255,0) fr=255.0;
      if (fg>255,0) fg=255.0;
      if (fb>255,0) fb=255.0;
      r=fr;g=fg;b=fb;

      if(!hds->image[x][y][3])
        putpixel(hds->render,x-(hds->current_frame*hds->w),y,makecol(255,0,255));
      else
          putpixel(hds->render,x-(hds->current_frame*hds->w),y,makecol(r,g,b));

    }

  }
}

void calc_text_normals(HDTEXT *text)
{
  int x,y;
  unsigned char a,b,c;
  for (x=0;x<text->bump->w-1;x++)
  {

    for (y=0;y<text->bump->h-1;y++)
    {
      a=getr(getpixel(text->bump,x+1,y));
      b=getr(getpixel(text->bump,x,y+1));
      c=getr(getpixel(text->bump,x,y));
      cross(a,b,c,text->normal[x][y]);
     // printf("%f %f ",text->normal[x][y][0],text->normal[x][y][1]);
    }
  }
}

// void typetext(HDTEXT *text,int duration, int fadein,int fadeout,unsigned char r, unsigned char g, unsigned char b ,const char* quote)
void typetext(HDTEXT *text,float speed,unsigned char r, unsigned char g, unsigned char b ,const char* quote)
{
 if (!text->duration)
 {
  text->r=r;
  text->g=g;
  text->b=b;
 // text->duration=duration;
 // text->maxduration=duration;
 // text->fadein=fadein;
 // text->fadeout=fadeout;
  text->textparameter=0.0;
  text->duration=1;
  text->lightx=-40.0;
  text->lightspeed=speed;
  clear_to_color(text->bump,makecol(0,0,0));
  textout_centre_ex(text->bump,letters,quote,TEXTX/2,(TEXTY-16)/2,makecol(255,255,255),makecol(0,0,0));
  calc_text_normals(text);
 }
}

void render_text(HDTEXT *text)
{
  unsigned char r,g,b,l;
  int x,y,xx,yy;
  float a,theta,fr,fg,fb,d,ffx,ffy;
  for (x=0;x<TEXTX;x++)
  {

    for (y=0;y<TEXTY;y++)
    {
    //  ffx=(fx-scroll-x)*1.0;
     // if (text==header) ffy=(fy+TEXTY-y)*1.0; else ffy=(fy-SIZEY-y)*1.0;
      ffx=text->lightx-(float)x;
      if (ffx==0.0) ffx=1.0;
      ffy=30.0-(float)y;
      d=sqrt(ffx*ffx+ffy*ffy);
      ffx/=d;ffy/=d;
      theta= (ffx*text->normal[x][y][0] + ffy*text->normal[x][y][1]);
    //  if(sqrt(hdr->normal[x][y][0]*hdr->normal[x][y][0] + hdr->normal[x][y][1]*hdr->normal[x][y][1])<.01) theta=.8;
    //  a=atan2((fx-x)*1.0,(fy-y)*1.0);
   //   theta=cos(hdr->normal[x][y]-a);
     theta*=-1;
      if (d) theta*=(6/d)*text->textintensity;
    //  if(sqrt(hdr->normal[x][y][0]*hdr->normal[x][y][0] + hdr->normal[x][y][1]*hdr->normal[x][y][1])<.01) theta/=(fintensity);
      theta-=1;
       if (theta<0.0) theta=0.0;
      if (theta>1.0) theta=1.0;
      //theta*=255;
    //  printf("%f\n",theta);
      l=theta;
      text->lum[x][y] = l;
      fr=text->r/255.0;
      fg=text->g/255.0;
      fb=text->b/255.0;
     // printf("%i",getr(text->colour));
      fr*=theta;fg*=theta;fb*=theta;
      if (key[KEY_Y]) printf("%1.3f",text->normal[x][y][0]);
      fr*=255.0;fg*=255.0;fb*=255.0;
      if (fr>255,0) fr=255.0;
      if (fg>255,0) fg=255.0;
      if (fb>255,0) fb=255.0;
      r=fr;g=fg;b=fb;

      if(!getpixel(text->bump,x,y))
        putpixel(text->render,x,y,makecol(r,g,b));
      else
          putpixel(text->render,x,y,makecol(r,g,b));

    }

  }
}


void textsystem()
{
  if (current_level==1)
  {
    if(fx==50  && !quotes[0]) {typetext(header,1.0,222,222,222,"Can you hear me?");quotes[0]=1;}
    if(fx==100 && !quotes[1]) {typetext(footer,2.0,222,222,222,"You must find me");quotes[1]=1;}
    if(fx==200 && !quotes[2]) {typetext(header,1.5,222,222,222,"I will guide you");quotes[2]=1;}
    if(fx==200 && !quotes[3]) {typetext(footer,.8,222,222,222,"Just listen to me");quotes[3]=1;}
    if(fx==300 && !quotes[4]) {typetext(header,.6,222,222,222,"Stay focused...");quotes[4]=1;}
    if(fx==380 && !quotes[5]) {typetext(footer,1.0,222,222,222,"This is Bahleda");quotes[5]=1;}
    if(fx==380 && !quotes[6]) {typetext(header,.7,222,222,222,"Pretty harmless");quotes[6]=1;}
    if(fx==580 && !quotes[7]) {typetext(footer,2.2,222,222,222,"Almost there!");quotes[7]=1;}
  }
  if (current_level==2)
  {
    if(fx==50  && !quotes[0]) {typetext(header,2.0,222,222,222,"Your story...");quotes[0]=1;}
    if(fx==60 && !quotes[1]) {typetext(footer,2.0,222,222,222,"It does not end here");quotes[1]=1;}
    if(fx==100 && !quotes[2]) {typetext(header,1.5,222,111,55,"Don't go too high!");quotes[2]=1;}
    if(fx==120 && !quotes[3]) {typetext(footer,.8,222,222,222,"Aim lower...");quotes[3]=1;}
    if(fx==160 && !quotes[4]) {typetext(header,2.0,222,222,222,"Your light");quotes[4]=1;}
    if(fx==170 && !quotes[5]) {typetext(footer,1.5,222,222,222,"It may awaken things");quotes[5]=1;}
    if(fx==330 && !quotes[6]) {typetext(header,1.5,222,222,222,"You carry a soul");quotes[6]=1;}
    if(fx==340 && !quotes[7]) {typetext(footer,1.5,222,222,222,"Don't let them take it");quotes[7]=1;}
    if(fx==450 && !quotes[8]) {typetext(header,1.8,222,222,222,"The Withering Trent");quotes[8]=1;}
    if(fx==450 && !quotes[9]) {typetext(footer,1.0,222,222,222,"Watch him closely");quotes[9]=1;}
  }
}

void set_light(int num,int x,int y, float phase, float wave, float light, float range)
{
  lights[num].lit=1;
  lights[num].x=x;
  lights[num].y=y;
  lights[num].phase=phase;
  lights[num].wave=wave;
  lights[num].light=light;
  lights[num].range=range;

}

void set_warpblock(int c,int x1,int y1,int x2,int y2,int lvl)
{
  warpblocks[c][0]=x1;
  warpblocks[c][1]=y1;
  warpblocks[c][2]=x2;
  warpblocks[c][3]=y2;
  warpblocks[c][4]=lvl;
}

void beginlevel(int lvlnum,int again)
{
  int c;
  unsigned int ls,le;
  if (again) printf("RE");
  printf("STARTING LEVEL %i\n",lvlnum);
  printf("Stopping previously loaded level...");
  printf(" OK!\n");
  if (stream && !again)
  {
    printf("Stopping music...");
    alogg_stop_streaming(stream);
    printf(" OK!\n");
  }
  if (!again)
  {
     for (c=0;c<NUMQUOTES;c++) quotes[c]=0;
     free(level);
     for (c=0;c<NUMSPRITES;c++) free(sprites[c]);
     for (c=0;c<NUMLIGHTS;c++) lights[c].lit=0;
     for (c=0;c<4;c++) warpblocks[c][4]=0;
  } else {
     for (c=0;c<sprites_amount;c++) reset_hd_sprite(sprites[c]);
  }

  if (lvlnum==1)
  {
     printf("Setting up enviroment\n");
     flx=30.0;fmx=30.0;
     fly=30.0;fmy=30.0;
     position_mouse(30*4,30*4);
     highlight=30.0;
     lowlight=20.0;
     header->light=6.0;
     footer->light=6.0;
     header->textparameter=1.0;
     footer->textparameter=1.0;
     scroll=0;
     fstamina=100;
     fparameter=0.0;
     gameover=0;
     printf("  starting position [ %3.1f , %3.1f ]\n",flx,fly);
     printf("  lighting proportions [ %3.1f , %3.1f ]\n",highlight, lowlight);
     printf("Loading graphics...");
     if (!again)
     {
       level = load_hd("level1_c.bmp","level1_b.bmp");
       sprites_amount=3;
       sprites[0] = load_hd_sprite("sprite_c.bmp","sprite_b.bmp",375,35,NEAR,.5,5,0,8);
       sprites[1] = load_hd_sprite("sprite3_c.bmp","sprite3_b.bmp",300,20,FLYING,.5,5,0,8);
       sprites[2] = load_hd_sprite("sprite8_c.bmp","sprite8_b.bmp",156,20,LOOP,.3,5,0,8);
       if (!level) printf("\n!!!LEVEL LOADING FAILED\n");
       for (c=0;c<sprites_amount;c++) if(!sprites[c]) printf("\n!!!LOADING SPRITE %i FAILED\n",c);
       set_warpblock(0,630,0,640,80,2);
     }
     printf(" OK!\n");
     printf("Beggining audio stream...");
    //  stream=alogg_start_streaming("excavation.ogg",BLOCK_SIZE);
    if (!again)
    {
      ls=378761;
      le=4915232;
       FSOUND_Stream_Close(handle);
       handle=FSOUND_Stream_Open("lv1.mp3",FSOUND_LOOP_NORMAL, 0, 0);
       //FSOUND_Stream_SetLoopPoints(handle,ls,le);
       FSOUND_Stream_Play (0,handle);

    }

     if (!stream) printf("!!!STREAMING OGG FAILED\n");
     printf(" OK!\n");
  }
  if (lvlnum==2)
  {
     printf("Setting up enviroment\n");
     flx=0.0;fmx=10.0;
     fly=32.0;fmy=32.0;
     position_mouse(5*4,32*4);
     highlight=40.0;
     lowlight=30.0;
     header->light=6.0;
     footer->light=6.0;
     header->textparameter=1.0;
     footer->textparameter=1.0;
     scroll=0;
     fstamina=100;
     fparameter=0.0;
     gameover=0;
     printf("  starting position [ %3.1f , %3.1f ]\n",flx,fly);
     printf("  lighting proportions [ %3.1f , %3.1f ]\n",highlight, lowlight);
     printf("Loading graphics...");
     if (!again)
     {
       level = load_hd("level2b_c.bmp","level2b_b.bmp");
       sprites_amount=9;
       sprites[3] = load_hd_sprite("sprite4_c.bmp","sprite4_b.bmp",180,45,NEARONCE,.8,2,0,8);
       sprites[4] = load_hd_sprite("sprite4_c.bmp","sprite4_b.bmp",200,45,NEARONCE,.8,2,0,8);
       sprites[5] = load_hd_sprite("sprite4_c.bmp","sprite4_b.bmp",220,45,NEARONCE,.8,2,0,8);
       sprites[0] = load_hd_sprite("sprite5_c.bmp","sprite5_b.bmp",180,40,FLYINGBUG,.9,2,0,8);
       sprites[1] = load_hd_sprite("sprite5_c.bmp","sprite5_b.bmp",200,40,FLYINGBUG,.9,2,0,8);
       sprites[2] = load_hd_sprite("sprite5_c.bmp","sprite5_b.bmp",220,40,FLYINGBUG,.9,2,0,8);
       sprites[6] = load_hd_sprite("sprite6_c.bmp","sprite6_b.bmp",344,18,NEAR,.6,2,0,8);           //344,18                  );
       sprites[7] = load_hd_sprite("sprite7_c.bmp","sprite7_b.bmp",491,42,NEARONCE,.4,15,1,8); ///491, 42
       sprites[8] = load_hd_sprite("skull2_c.bmp","skull2_b.bmp",540,10,TRIGGERONCE,.5,600,0,8);
     //  sprites[1] = load_hd_sprite("sprite3_c.bmp","sprite3_b.bmp",300,20,FLYING,.5,5);

       set_warpblock(0,630,0,640,80,3);
     }
          printf("Beggining audio stream...");
    // if (!again) stream=alogg_start_streaming("woodland.ogg",BLOCK_SIZE);
        if (!again)
    {
      ls=378761;
      le=4915232;
       FSOUND_Stream_Close(handle);
       handle=FSOUND_Stream_Open("woodland.ogg",FSOUND_LOOP_NORMAL, 0, 0);
       //FSOUND_Stream_SetLoopPoints(handle,ls,le);
       FSOUND_Stream_Play (0,handle);

    }
     if (!stream) printf("NO MUSIC!");
     printf(" OK!\n");
  }
  if (lvlnum==3)
  {
     printf("Setting up enviroment\n");
     flx=20.0;fmx=20.0;
     fly=32.0;fmy=32.0;
     position_mouse(20*4,32*4);
     highlight=30.0;
     lowlight=20.0;
     header->light=6.0;
     footer->light=6.0;
     header->textparameter=1.0;
     footer->textparameter=1.0;
     scroll=0;
     fstamina=100;
     fparameter=0.0;
     gameover=0;
     printf("  starting position [ %3.1f , %3.1f ]\n",flx,fly);
     printf("  lighting proportions [ %3.1f , %3.1f ]\n",highlight, lowlight);
     printf("Loading graphics...");
     if (!again)
     {

       level = load_hd("level3_c.bmp","level3_b.bmp");

       sprites_amount=8;

       sprites[0] = load_hd_sprite("grass2_c.bmp","grass2_b.bmp",44,40,WINDED,.5,5,0,8);
       sprites[1] = load_hd_sprite("lilflame1_c.bmp","lilflame1_c.bmp",536,30,LOOP,.9,5,2,8);
       sprites[2] = load_hd_sprite("window_c.bmp","window_c.bmp",363,54,LOOP,.2*(M_PI/4),0,2,8);
       sprites[3] = load_hd_sprite("window_c.bmp","window_c.bmp",423,54,LOOP,.2*(M_PI/4),0,2,8);
       sprites[4] = load_hd_sprite("skull1_c.bmp","skull1_b.bmp",-40,5,STEPWALK,.2,8,0,8);
       sprites[5] = load_hd_sprite("eye1_c.bmp","eye1_c.bmp",29,11,CONNECTED,.1,5,1,8);
       sprites[6] = load_hd_sprite("grass2_c.bmp","grass2_b.bmp",172,40,WINDED,.5,5,0,8);
       sprites[7] = load_hd_sprite("scarecrow1_c.bmp","scarecrow1_b.bmp",156,20,WINDED,.5,5,0,8);
      // sprites[8] = load_hd_sprite("record1_c.bmp","record1_b.bmp",10,10,LOOP,.5,5,0,8);

       sprite_connections_count = 1;
       sprite_connections[0][0]=4;
       sprite_connections[0][1]=5;
       sprite_connections[0][2]=19;
       sprite_connections[0][3]=6;

       set_light(0,547,35,0.0,1.0,20.0,5.0);
       set_light(1,527,35,0.0,1.1,20.0,5.0);

      // set_light(2,608,35,0.0,.9,20.0,5.0);
      // set_light(3,628,35,0.0,.8,20.0,5.0);

       set_light(2,368,54,0.0,.2,20.0,5.0);
       set_light(3,428,54,0.0,.2,20.0,5.0);

       set_warpblock(0,335,45,340,60,4);

     }
          printf("Beggining audio stream...");
   //  if (!again) stream=alogg_start_streaming("leni.ogg",BLOCK_SIZE);
           if (!again)
    {
      ls=378761;
      le=4915232;
       FSOUND_Stream_Close(handle);
       handle=FSOUND_Stream_Open("leni.ogg",FSOUND_LOOP_NORMAL, 0, 0);
       //FSOUND_Stream_SetLoopPoints(handle,ls,le);
       FSOUND_Stream_Play (0,handle);

    }
     if (!stream) printf("NO MUSIC!");
     printf(" OK!\n");

  }
  if (lvlnum==4)
  {
     printf("Setting up enviroment\n");
     flx=20.0;fmx=20.0;
     fly=32.0;fmy=32.0;
     position_mouse(20*4,32*4);
     highlight=30.0;
     lowlight=20.0;
     header->light=6.0;
     footer->light=6.0;
     header->textparameter=1.0;
     footer->textparameter=1.0;
     scroll=0;
     fstamina=100;
     fparameter=0.0;
     gameover=0;
     printf("  starting position [ %3.1f , %3.1f ]\n",flx,fly);
     printf("  lighting proportions [ %3.1f , %3.1f ]\n",highlight, lowlight);
     printf("Loading graphics...");
     if (!again)
     {

       level = load_hd("level4_c.bmp","level4_b.bmp");

       sprites_amount=3;
       sprites[0] = load_hd_sprite("record1_c.bmp","record1_b.bmp",452,16,LOOP,.5,5,0,8);
       sprites[1] = load_hd_sprite("fireplace1_c.bmp","fireplace1_c.bmp",390,65,LOOP,.8,5,1,8);
       sprites[2] = load_hd_sprite("spider1_c.bmp","spider1_b.bmp",280,10,NEAR,.5,5,0,11);
       //sprites[3] = load_hd_sprite("cat_c.bmp","cat_b.bmp",10,16,LOOP,.5,0,0,8);

       set_light(0,395,68,0.0,1.0,60.0,8.0);
       set_light(1,238,50,0.0,1.0,20.0,1.0);
       set_light(2,248,50,0.0,1.0,20.0,1.0);

       sprite_connections_count = 0;

       set_warpblock(0,633,30,640,50,6);
       set_warpblock(1,460,20,465,30,5);



     }
          printf("Beggining audio stream...");
   //  if (!again) stream=alogg_start_streaming("lurking.ogg",BLOCK_SIZE);
              if (!again)
    {
      ls=378761;
      le=4915232;
       FSOUND_Stream_Close(handle);
       handle=FSOUND_Stream_Open("lurking.ogg",FSOUND_LOOP_NORMAL, 0, 0);
       //FSOUND_Stream_SetLoopPoints(handle,ls,le);
       FSOUND_Stream_Play (0,handle);

    }

     if (!stream) printf("NO MUSIC!");
     printf(" OK!\n");

  }
  if (lvlnum==5)
  {
     printf("Setting up enviroment\n");
     flx=20.0;fmx=20.0;
     fly=32.0;fmy=32.0;
     position_mouse(20*4,32*4);
     highlight=80.0;
     lowlight=70.0;
     header->light=6.0;
     footer->light=6.0;
     header->textparameter=1.0;
     footer->textparameter=1.0;
     scroll=0;
     fstamina=100;
     fparameter=0.0;
     gameover=0;
     printf("  starting position [ %3.1f , %3.1f ]\n",flx,fly);
     printf("  lighting proportions [ %3.1f , %3.1f ]\n",highlight, lowlight);
     printf("Loading graphics...");
     if (!again)
     {

       level = load_hd("mario_c.bmp","mario_b.bmp");

       sprites_amount=0;




       sprite_connections_count = 0;
       set_warpblock(0,630,0,640,80,1);

     }
          printf("Beggining audio stream...");
    // if (!again) stream=alogg_start_streaming("mario.ogg",BLOCK_SIZE);
                  if (!again)
    {
      ls=378761;
      le=4915232;
       FSOUND_Stream_Close(handle);
       handle=FSOUND_Stream_Open("mario.ogg",FSOUND_LOOP_NORMAL, 0, 0);
       //FSOUND_Stream_SetLoopPoints(handle,ls,le);
       FSOUND_Stream_Play (0,handle);
    }

     if (!stream) printf("NO MUSIC!");
     printf(" OK!\n");

  }
  if (lvlnum==6)
  {
     printf("Setting up enviroment\n");
     flx=465.0;fmx=465.0;
     fly=55.0;fmy=55.0;
     position_mouse(65*4,55*4);
     highlight=30.0;
     lowlight=20.0;
     header->light=6.0;
     footer->light=6.0;
     header->textparameter=1.0;
     footer->textparameter=1.0;
     scroll=400;
     fstamina=100;
     fparameter=0.0;
     gameover=0;
     printf("  starting position [ %3.1f , %3.1f ]\n",flx,fly);
     printf("  lighting proportions [ %3.1f , %3.1f ]\n",highlight, lowlight);
     printf("Loading graphics...");
     if (!again)
     {

       level = load_hd("level3_c.bmp","level3_b.bmp");

       sprites_amount=4;

       sprites[0] = load_hd_sprite("grass2_c.bmp","grass2_b.bmp",44,40,WINDED,.5,5,0,8);
       sprites[1] = load_hd_sprite("lilflame1_c.bmp","lilflame1_c.bmp",536,30,LOOP,.9,5,2,8);
       sprites[2] = load_hd_sprite("window_c.bmp","window_c.bmp",363,54,LOOP,.2*(M_PI/4),0,2,8);
       sprites[3] = load_hd_sprite("window_c.bmp","window_c.bmp",423,54,LOOP,.2*(M_PI/4),0,2,8);
      // sprites[4] = load_hd_sprite("skull1_c.bmp","skull1_b.bmp",400,12,STEPWALK,.2,8,0,8);
     //  sprites[5] = load_hd_sprite("eye1_c.bmp","eye1_c.bmp",29,11,CONNECTED,.1,5,1,8);
     //  sprites[6] = load_hd_sprite("grass2_c.bmp","grass2_b.bmp",172,40,WINDED,.5,5,0,8);
     //  sprites[7] = load_hd_sprite("scarecrow1_c.bmp","scarecrow1_b.bmp",156,20,WINDED,.5,5,0,8);
      // sprites[8] = load_hd_sprite("record1_c.bmp","record1_b.bmp",10,10,LOOP,.5,5,0,8);

       sprite_connections_count = 0;

       set_light(0,547,35,0.0,1.0,20.0,5.0);
       set_light(1,527,35,0.0,1.1,20.0,5.0);

      // set_light(2,608,35,0.0,.9,20.0,5.0);
      // set_light(3,628,35,0.0,.8,20.0,5.0);

       set_light(2,368,54,0.0,.2,20.0,5.0);
       set_light(3,428,54,0.0,.2,20.0,5.0);

       set_warpblock(0,335,45,340,60,4);

     }
          printf("Beggining audio stream...");
   //  if (!again) stream=alogg_start_streaming("leni.ogg",BLOCK_SIZE);
     if (!stream) printf("NO MUSIC!");
     printf(" OK!\n");

  }


  printf("DONE!\n");
}


void draw_warpblocks()
{
 int c;
 for (c=0;c<4;c++)
 {
  if (warpblocks[c][4])
  {
    rect(active_page,warpblocks[c][0]-scroll,warpblocks[c][1]+20,warpblocks[c][2]-scroll,warpblocks[c][3]+20,makecol(255,255,255));
  }
 }
}

int in_warpblocks()
{
 int c;
 for (c=0;c<4;c++)
 {
  if (fx>warpblocks[c][0] && fx<warpblocks[c][2] && fy>warpblocks[c][1] && fy<warpblocks[c][3]) return warpblocks[c][4];
 }
 return 0;
}

void check_lvl()
{
  if (in_warpblocks())
   {
     fade+=80;
     if (fade>255) fade=255;
     if (fade==255)
     {
      current_level = in_warpblocks();
      if (current_level<=LEVELS) {beginlevel(current_level,0);} else theend=1;
     }

   } else {
   fade-=16;
   if (fade<0) fade=0;
   }
}

void explode_firefly()
{
   int p;
   for (p=0;p<NUMPARTICLES;p++)
   {
     particles[p][0]=fx;
     particles[p][1]=fy;
     particles[p][2]=5-(rand()%10);
     particles[p][3]=(rand()%6)-7;
     particles[p][4]=1;
   }
   if (!DEBUGMODE) play_sample(glass,255,128,1000,0);
}

void draw_particle()
{
   int p;
   for (p=0;p<NUMPARTICLES;p++)
   {
     if (particles[p][4])
     {
        putpixel(active_page,((particles[p][0]-scroll)),particles[p][1]+20,makecol(255,255,255));
     }
   }
}

void draw_firefly()
{
  int c;
  c=255.0*fparameter;
  if (c>255) c=255;
  /*
   if (flap)
     {rectfill(active_page,((fx-scroll)*4),fy*4+80,((fx-scroll)*4)+8,(fy*4)-4+80,makecol(c,c,c));flap=0;}
     else
     {rectfill(active_page,((fx-scroll)*4),fy*4+80,((fx-scroll)*4)+4,(fy*4)-8+80,makecol(c,c,c));flap=1;}
*/
 if (flap)
 {
   putpixel(active_page,((fx-scroll))+1,fy+20,makecol(c,c,c));
   putpixel(active_page,((fx-scroll)),fy+20,makecol(c,c,c));

 } else {
     putpixel(active_page,((fx-scroll)),fy+20,makecol(c,c,c));
     putpixel(active_page,((fx-scroll)),fy+20-1,makecol(c,c,c));

 }
 flap^=1;

}

void setup_camera()
{
#ifdef _WIN32
    capture = cvCaptureFromCAM(0);
    cvSetCaptureProperty(capture, CV_CAP_PROP_FRAME_WIDTH, 160);
    cvSetCaptureProperty(capture, CV_CAP_PROP_FRAME_HEIGHT, 120);
		cvSetCaptureProperty(capture, CV_CAP_PROP_FPS, 15);
		cvSetCaptureProperty(capture, CV_CAP_PROP_BRIGHTNESS, -10);
    cvSetCaptureProperty(capture, CV_CAP_PROP_CONTRAST, 20);
    cvSetCaptureProperty(capture, CV_CAP_PROP_HUE, 6);
    cvSetCaptureProperty(capture, CV_CAP_PROP_SATURATION, 80);
    //cvSetCaptureProperty(capture, CV_CAP_PROP_GAIN,2);
    //cvSetCaptureProperty(capture, CV_CAP_PROP_CONVERT_RGB, 0 );
    //cvSetCaptureProperty(capture, CV_CAP_PROP_FORMAT,1 );
#endif
#ifdef linux

    unsigned int i;
      CLEAR(ctl);
  CLEAR(parm);
    	fd = v4l2_open(dev_name, O_RDWR | O_NONBLOCK, 0);
	if (fd < 0) {
		perror("Cannot open device");
		exit(EXIT_FAILURE);
	}


	CLEAR(fmt);
	fmt.type = V4L2_BUF_TYPE_VIDEO_CAPTURE;
	fmt.fmt.pix.width       = 160;
	fmt.fmt.pix.height      = 120;
	fmt.fmt.pix.pixelformat = V4L2_PIX_FMT_RGB24;
	fmt.fmt.pix.field       = V4L2_FIELD_INTERLACED;
	xioctl(fd, VIDIOC_S_FMT, &fmt);
	if (fmt.fmt.pix.pixelformat != V4L2_PIX_FMT_RGB24) {
		printf("Libv4l didn't accept RGB24 format. Can't proceed.\n");
		exit(EXIT_FAILURE);
	}
	if ((fmt.fmt.pix.width != 160) || (fmt.fmt.pix.height != 120))
		printf("Warning: driver is sending image at %dx%d\n",
			fmt.fmt.pix.width, fmt.fmt.pix.height);


	CLEAR(req);
	req.count = 2;
	req.type = V4L2_BUF_TYPE_VIDEO_CAPTURE;
	req.memory = V4L2_MEMORY_MMAP;
	xioctl(fd, VIDIOC_REQBUFS, &req);

	buffers = calloc(req.count, sizeof(*buffers));
	for (n_buffers = 0; n_buffers < req.count; ++n_buffers) {
		CLEAR(buf);

		buf.type        = V4L2_BUF_TYPE_VIDEO_CAPTURE;
		buf.memory      = V4L2_MEMORY_MMAP;
		buf.index       = n_buffers;

		xioctl(fd, VIDIOC_QUERYBUF, &buf);

		buffers[n_buffers].length = buf.length;
		buffers[n_buffers].start = v4l2_mmap(NULL, buf.length,
			      PROT_READ | PROT_WRITE, MAP_SHARED,
			      fd, buf.m.offset);

		if (MAP_FAILED == buffers[n_buffers].start) {
			perror("mmap");
			exit(EXIT_FAILURE);
		}
	}

	for (i = 0; i < n_buffers; ++i) {
		CLEAR(buf);
		buf.type = V4L2_BUF_TYPE_VIDEO_CAPTURE;
		buf.memory = V4L2_MEMORY_MMAP;
		buf.index = i;
		xioctl(fd, VIDIOC_QBUF, &buf);
	}
	type = V4L2_BUF_TYPE_VIDEO_CAPTURE;


    parm.type=V4L2_BUF_TYPE_VIDEO_CAPTURE;
    parm.parm.capture.capability=V4L2_CAP_TIMEPERFRAME;
    parm.parm.capture.capturemode=0;
    parm.parm.capture.timeperframe.numerator=1;
    parm.parm.capture.timeperframe.denominator=15;
    parm.parm.capture.readbuffers=2;
    xioctl(fd,VIDIOC_S_PARM,&parm);

	xioctl(fd, VIDIOC_STREAMON, &type);


printf("!");
    ctl.id=V4L2_CID_CONTRAST;
    ctl.value=20;
    xioctl(fd,VIDIOC_S_EXT_CTRLS,&ctl);
printf("!");
    ctl.id=V4L2_CID_BRIGHTNESS;
    ctl.value=-10;
    xioctl(fd,VIDIOC_S_EXT_CTRLS,&ctl);
printf("!");
    ctl.id=V4L2_CID_SATURATION;
    ctl.value=80;
    xioctl(fd,VIDIOC_S_EXT_CTRLS,&ctl);
printf("!");
    ctl.id=V4L2_CID_HUE;
    ctl.value=6;
    xioctl(fd,VIDIOC_S_EXT_CTRLS,&ctl);
printf("!");
    ctl.id=V4L2_CID_GAMMA;
    ctl.value=120;
    xioctl(fd,VIDIOC_S_EXT_CTRLS,&ctl);
printf("!");
    ctl.id=V4L2_CID_POWER_LINE_FREQUENCY;
    ctl.value=2;
    xioctl(fd,VIDIOC_S_EXT_CTRLS,&ctl);
printf("!");
    ctl.id=V4L2_CID_SHARPNESS;
    ctl.value=1;
    xioctl(fd,VIDIOC_S_EXT_CTRLS,&ctl);
printf("!");
    ctl.id=V4L2_CID_BACKLIGHT_COMPENSATION;
    ctl.value=1;
    xioctl(fd,VIDIOC_S_EXT_CTRLS,&ctl);
printf("!");
    ctl.id=V4L2_CID_AUTO_WHITE_BALANCE;
    ctl.value=1;
    xioctl(fd,VIDIOC_S_EXT_CTRLS,&ctl);
printf("!");
    ctl.id=V4L2_CID_RED_BALANCE;
    ctl.value=-100;
    xioctl(fd,VIDIOC_S_EXT_CTRLS,&ctl);
printf("!");
    ctl.id=V4L2_CID_BLUE_BALANCE;
    ctl.value=100;
    xioctl(fd,VIDIOC_S_EXT_CTRLS,&ctl);

#endif
}

void find_candle()
{
#ifdef _WIN32
      unsigned int i;
    int x,y,c,f,maxx,maxy,minx,miny,cx,cy,madeit,sp;
    unsigned char red,green,blue,sr,sg,sb,gray;
    float fr,fg,fb,ff;
    madeit=0;candlesize=0;

			frame = cvQueryFrame( capture );
      x=0;y=0;c=0;minx=169;miny=99;maxx=0;maxy=20;
      for(f=0;f<frame->imageSize;f++)
        {
            if(c==2) red=frame->imageData[f];
            if(c==1) green=frame->imageData[f];
            if(c==0) blue=frame->imageData[f];
            c++;

            if (c>2)
            {
                c=0;
                x++;
                /*
                fr=red/255.0;
                fg=green/255.0;
                fb=blue/255.0;
                fr*=fr*fr*fr;fg*=fg*fg*fg;fb*=fb*fb*fb;
                fr*=255.0;fg*=255.0;fb*=255.0;
                red=fr;green=fg;blue=fb;
                */
                ff=(red+green+blue)/(255.0*3.0);
                ff*=ff*ff;



                ff*=255.0;
                red=ff;green=ff;blue=ff;

                if (red>200 && green>200 && blue>200 && y>20 && y<100)
                {
                  if(x>maxx) maxx=x;
                  if(x<minx) minx=x;
                  if(y>maxy) maxy=y;
                  if(y<miny) miny=y;
                  madeit=1;candlesize++;
                }
                if (ff>100)
                {
                  ff/=255.0;
                  sp=getpixel(active_page,159-x,y);
                  sr=getr(sp);sg=getb(sp);sb=getb(sp);
                  fr=sr/255.0;fg=sg/255.0;fb=sb/255.0;
                  fr+=(ff/2.0);fg+=(ff/2.0);fb+=(ff/2.0);
                  if (fr>1.0) fr=1.0;
                  if (fg>1.0) fg=1.0;
                  if (fb>1.0) fb=1.0;
                  fr*=255.0;fg*=255.0;fb*=255.0;
                  sr=fr;sg=fg;sb=fb;
                  putpixel(active_page,159-x,y,makecol(sr,sg,sb));
                }
            }
            if (x>159) {x=0;y++;}


        }
        cx=159-((maxx+minx)/2);
        cy=(maxy+miny)/2;
        if (madeit)
        {
        //    putpixel(active_page,cx,cy,makecol(0,0,0));
        //    putpixel(active_page,cx,cy,makecol(255,255,255));
            fmx=cx;
            fmx+=scroll;
            fmy=cy;
            fmy-=20;
        }

#endif

#ifdef linux

    unsigned int i;
    int x,y,c,f,maxx,maxy,minx,miny,cx,cy,madeit,sp;
    unsigned char red,green,blue,sr,sg,sb,gray;
    float fr,fg,fb,ff;
    madeit=0;candlesize=0;

				do {
			FD_ZERO(&fds);
			FD_SET(fd, &fds);

			/* Timeout. */
			tv.tv_sec = 2;
			tv.tv_usec = 0;

			r = select(fd + 1, &fds, NULL, NULL, &tv);
		} while ((r == -1 && (errno = EINTR)));
		if (r == -1) {
			perror("select");
			return errno;
		}

		CLEAR(buf);
		buf.type = V4L2_BUF_TYPE_VIDEO_CAPTURE;
		buf.memory = V4L2_MEMORY_MMAP;
		xioctl(fd, VIDIOC_DQBUF, &buf);
        x=0;y=0;c=0;minx=169;miny=99;maxx=0;maxy=20;
        for(f=0;f<buf.bytesused;f++)
        {
            if(c==0) red=buffers[buf.index].start[f];
            if(c==1) green=buffers[buf.index].start[f];
            if(c==2) blue=buffers[buf.index].start[f];
            c++;

            if (c>2)
            {
                c=0;
                x++;
                /*
                fr=red/255.0;
                fg=green/255.0;
                fb=blue/255.0;
                fr*=fr*fr*fr;fg*=fg*fg*fg;fb*=fb*fb*fb;
                fr*=255.0;fg*=255.0;fb*=255.0;
                red=fr;green=fg;blue=fb;
                */
                ff=(red+green+blue)/(255.0*3.0);
                ff*=ff*ff;



                ff*=255.0;
                red=ff;green=ff;blue=ff;

                if (red>200 && green>200 && blue>200 && y>20 && y<100)
                {
                  if(x>maxx) maxx=x;
                  if(x<minx) minx=x;
                  if(y>maxy) maxy=y;
                  if(y<miny) miny=y;
                  madeit=1;candlesize++;
                }
                if (ff>100.0)
                {
                  ff/=255.0;
                  sp=getpixel(active_page,159-x,y);
                  sr=getr(sp);sg=getb(sp);sb=getb(sp);
                  fr=sr/255.0;fg=sg/255.0;fb=sb/255.0;
                  fr+=(ff/2.0);fg+=(ff/2.0);fb+=(ff/2.0);
                  if (fr>1.0) fr=1.0;
                  if (fg>1.0) fg=1.0;
                  if (fb>1.0) fb=1.0;
                  fr*=255.0;fg*=255.0;fb*=255.0;
                  sr=fr;sg=fg;sb=fb;
                  putpixel(active_page,159-x,y,makecol(sr,sg,sb));
                }
            }
            if (x>159) {x=0;y++;}


        }
        cx=159-((maxx+minx)/2);
        cy=(maxy+miny)/2;
        if (madeit)
        {
        //    putpixel(active_page,cx,cy,makecol(0,0,0));
        //    putpixel(active_page,cx,cy,makecol(255,255,255));
            fmx=cx;
            fmx+=scroll;
            fmy=cy;
            fmy-=20;
        }
      //  stretch_blit(active_page,screen,0,0,160,120,0,0,640,480);
       // vsync();
        /*
		sprintf(out_name, "out%03d.ppm", i);
		fout = fopen(out_name, "w");
		if (!fout) {
			perror("Cannot open image");
			exit(EXIT_FAILURE);
		}
		fprintf(fout, "P6\n%d %d 255\n",
			fmt.fmt.pix.width, fmt.fmt.pix.height);
		fwrite(buffers[buf.index].start, buf.bytesused, 1, fout);
		fclose(fout);
*/
		xioctl(fd, VIDIOC_QBUF, &buf);

#endif

}

void rysuj()
{
int c,x,y,sp,sr,sg,sb;
float fr,fg,fb;
  if (!theend) {
  for (c=0;c<sprites_amount;c++)
  {
    if (!sprites[c]->plain)
    {
      render_hd_sprite(sprites[c]);
      masked_blit(sprites[c]->render,active_page,0,0,(sprites[c]->x-scroll),(20+sprites[c]->y),sprites[c]->w,sprites[c]->h);
    }
  }
  if (fparameter>0.0)
  {
  for (c=0;c<sprites_amount;c++)
  {
  if (sprites[c]->plain==1)
    {
      masked_blit(sprites[c]->plainrender,active_page,0+(sprites[c]->current_frame*sprites[c]->w),0,(sprites[c]->x-scroll),(20+sprites[c]->y),sprites[c]->w,sprites[c]->h);
    }

  }
  }
  render_hdr(level);
  render_text(header);
  render_text(footer);
  masked_blit(level->render,active_page,0+scroll,0,0,20,160,80);
  if (fparameter>0.0)
  {
  for (c=0;c<sprites_amount;c++)
  {
  if (sprites[c]->plain==2)
    {
      masked_blit(sprites[c]->plainrender,active_page,0+(sprites[c]->current_frame*sprites[c]->w),0,(sprites[c]->x-scroll),(20+sprites[c]->y),sprites[c]->w,sprites[c]->h);
    }

  }
  }
  //draw_warpblocks();
   if (header->duration) blit(header->render,active_page,0,0,0,0,159,19);
   if (footer->duration) blit(footer->render,active_page,0,0,0,100,159,19);
   if (!gameover) draw_firefly();

  draw_particle();

  if (mouse_driven) {
    if (fade)
    {
    for (x=0;x<160;x++)
    {
      for(y=0;y<120;y++)
      {

                  sp=getpixel(active_page,x,y);
                  sr=getr(sp)+fade;sg=getg(sp)+fade;sb=getb(sp)+fade;
                  if (sr>255) sr=255;
                  if (sg>255) sg=255;
                  if (sb>255) sb=255;
                  if (sr<0) sr=0;
                  if (sg<0) sg=0;
                  if (sb<0) sb=0;
                  putpixel(active_page,x,y,makecol(sr,sg,sb));
      }
    }
    }
  }
  } else
    textprintf_centre_ex(active_page, font, 80, 60  , makecol(255, 255, 255), -1, "You finished %i levels in %i seconds.",current_level,playtime/30);

/*
  textprintf_ex(active_page, font, 10, 10  , makecol(128, 255, 64), -1, "Stamina: %i",fstamina);
  textprintf_ex(active_page, font, 10, 20  , makecol(128, 255, 64), -1, "X: %3.2f %i %1.3f",flx,fx,fvx);
  textprintf_ex(active_page, font, 10, 30  , makecol(128, 255, 64), -1, "Y: %3.2f %i %1.3f",fly,fy,fvy);
  textprintf_ex(active_page, font, 10, 40  , makecol(128, 255, 64), -1, "MX: %1.2f",fmx);
  textprintf_ex(active_page, font, 10, 50  , makecol(128, 255, 64), -1, "MY: %1.2f",fmy);
  textprintf_ex(active_page, font, 10, 60  , makecol(128, 255, 64), -1, "cnd: %i",candlesize);
  textprintf_ex(active_page, font, 10, 70  , makecol(128, 255, 64), -1, "scr: %i",scroll);
  */
//  if (fx<SIZEX && fy>0 && fy<SIZEY)
  //  textprintf_ex(active_page, font, 10, 80  , makecol(128, 255, 64), -1, "under: %i",level->image[fx][fy][3]);



  //stretch_sprite(active_page,test.render,0,0,640,480);
  //  blit(test.render,active_page,0,0,0,0,160,120);

}


void timer_proc()
{
  int p,g,sx,sy,r,w;
  if (!theend) playtime++;
 //if (capturenow) find_candle();
 //capturenow^=1;
 wind=((rand()%256)/2560.0)-.05;
 //printf("%f ",wind);
 if (mouse_driven)
 {
   fmx = mouse_x/4.0;
   fmx+=scroll;
   fmy = mouse_y/4.0;
   mx = mouse_x/4;
   mx+=scroll;
   my = mouse_y/4;
   candlesize=50;
 }
  fcandle=(candlesize/50.0);

     //if (candlesize==0) fstamina-=5;

   fspeed=fstamina/100.0;
   fvx=(fmx-flx);
   fvy=(fmy-fly);
   fvd=sqrt(fvx*fvx+fvy*fvy);
   if (fvd) {fvx/=fvd;fvy/=fvd;} else {fvx=0.0;fvy=0.0;}
   flx+=fvx*fspeed*(FASTMODE ? 2.5 : .5);
   fly+=fvy*fspeed*(FASTMODE ? 2.5 : .5);

   /*
   if (fmx>flx) flx+=fstamina/200.0;
   if (fmx<flx) flx-=fstamina/200.0;
*/
   if (fmy<fly) {fstamina--;}
   if (fmy>fly) {fstamina++;}


   if (fly<30); else {if (fmy=fly) fstamina++;}
   if (fstamina<0) fstamina=0;
   if (fstamina>100) fstamina=100;
   if (fstamina<50) {fworn=1.0;fly+=1.0-fspeed;fregen=1;} else fworn=1.0;
   if (fregen) fstamina++;
   if (fstamina>80) fregen=0;

  // if (rand()%16==13) frange=5;
    if (frange>0) fintensity=fparameter*highlight*fsine*fcandle; else fintensity=fcandle*fparameter*lowlight*fsine*fworn*((50.0+fstamina)/150.0);
  //
    if (fstamina<0) fstamina-=15;

    header->textintensity=30.0*header->textparameter;//fintensity*header->light*header->textparameter;
    footer->textintensity=30.0*footer->textparameter;//fintensity*footer->light*footer->textparameter;

   fx=flx;
   fy=fly;
   if (!mouse_driven) mx=fmx;my=fmy;

   if (fx-scroll>100) scroll+=(FASTMODE ? 5 : 1);
   if (scroll>SIZEX-160) scroll=SIZEX-160;
   if (fx-scroll<60) scroll-=(FASTMODE ? 5 : 1);
   if (scroll<0) scroll=0;
   fwave+=1.0;
   fsine=(.05*sin(fwave))+1.0;
   frange--;
   tt++;
   if (!gameover)
   {
     fparameter+=.01;
     if (fparameter>1.0) fparameter=1.0;
   } else {
     fparameter-=1.0;
     if (fparameter<0.0) fparameter=0.0;
   }

   if (mouse_driven)
   {
     if (mouse_b & 1) {fintensity*=2.5;fstamina-=5;}
     if (mouse_b & 2) {fintensity*=0.0;fstamina+=5;}
   }

  // if (key[KEY_A]) typetext(footer,200,150,50,222,222,222,"I, Sos am the tomato!?");
 //  if (key[KEY_A]) typetext(header,200,150,50,222,222,222,"Hello world.");
/*
   header->duration--;
   if (header->duration<0) header->duration=0;
   if (header->duration>header->fadein)
   {
     header->textparameter=1.0-((header->duration-header->fadein)/((header->maxduration-header->fadein)*1.0));
   } else {
     if (header->duration<header->fadeout)
     {
       header->textparameter=header->duration/(header->fadeout*1.0);
     } else header->textparameter=1.0;
   }

   footer->duration--;
   if (footer->duration<0) footer->duration=0;
   if (footer->duration>footer->fadein)
   {
     footer->textparameter=1.0-((footer->duration-footer->fadein)/((footer->maxduration-footer->fadein)*1.0));
   } else {
     if (footer->duration<footer->fadeout)
     {
       footer->textparameter=footer->duration/(footer->fadeout*1.0);
     } else footer->textparameter=1.0;
   }
*/

textsystem();
   if (header->duration)
   {
     header->lightx+=header->lightspeed;
     if (header->lightx>200.0) header->duration=0;
     if (header->lightx<160.0)
     {
       header->textparameter+=(header->lightspeed/40.0);
       if (header->textparameter>1.0) header->textparameter=1.0;
     } else {
       header->textparameter-=(header->lightspeed/40.0);
       if (header->textparameter<0.0) header->textparameter=0.0;
     }
   }

   if (footer->duration)
   {
     footer->lightx+=footer->lightspeed;
     if (footer->lightx>200.0) footer->duration=0;
     if (footer->lightx<160.0)
     {
       footer->textparameter+=(footer->lightspeed/40.0);
       if (footer->textparameter>1.0) footer->textparameter=1.0;
     } else {
       footer->textparameter-=(footer->lightspeed/40.0);
       if (footer->textparameter<0.0) footer->textparameter=0.0;
     }
   }

   if (level->image[fx][fy][3]>20 && !gameover) {gameover=50;fparameter=10.0;explode_firefly();}

   for (p=0;p<NUMPARTICLES;p++)
   {
     if (particles[p][4])
     {
      particles[p][0]+=particles[p][2];
      particles[p][1]+=particles[p][3];
      particles[p][3]++;
     }
     if (particles[p][1]>SIZEY) particles[p][4]=0;
   }
   for (p=0;p<sprites_amount;p++)
   {
     if (sprites[p]->mode==NEAR)
     {
       if (fx>(sprites[p]->x-sprites[p]->parameter) && fx<(sprites[p]->x+sprites[p]->w+sprites[p]->parameter))
       {
         sprites[p]->fframe+=sprites[p]->framerate;
         if (sprites[p]->fframe>(sprites[p]->numframes)) sprites[p]->fframe=7.0;
         sprites[p]->current_frame=sprites[p]->fframe;
       } else {
         sprites[p]->fframe-=sprites[p]->framerate;
         if (sprites[p]->fframe<0) sprites[p]->fframe=0.0;
         sprites[p]->current_frame=sprites[p]->fframe;
       }
     }
     if (sprites[p]->mode==LOOP)
     {
       sprites[p]->fframe+=sprites[p]->framerate;
       if (sprites[p]->fframe>(sprites[p]->numframes)) sprites[p]->fframe-=(sprites[p]->numframes);
       sprites[p]->current_frame=sprites[p]->fframe;
     }

     if (sprites[p]->mode==WINDED)
     {
       sprites[p]->framerate+=wind;
       if (sprites[p]->framerate>1.0) sprites[p]->framerate=1.0;
       if (sprites[p]->framerate<.4) sprites[p]->framerate=.4;
       sprites[p]->fframe+=sprites[p]->framerate;
       if (sprites[p]->fframe>(sprites[p]->numframes)) sprites[p]->fframe-=(sprites[p]->numframes);
       sprites[p]->current_frame=sprites[p]->fframe;
     }

     if (sprites[p]->mode==STEPWALK)
     {
       if (!((sprites[p]->current_frame+1)%((sprites[p]->numframes)/2)))
       {
         if (!sprites[p]->delay) sprites[p]->delay=sprites[p]->parameter; else
         {
           sprites[p]->delay--;
           if (!sprites[p]->delay) {sprites[p]->current_frame++;sprites[p]->fframe+=1.0;}
         }
       }
       if (!sprites[p]->delay)
       {
       if ((int)(sprites[p]->fframe*(sprites[p]->framerate*10.0))<(int)((sprites[p]->fframe+sprites[p]->framerate)*(sprites[p]->framerate*10.0)))
       {
         sprites[p]->x++;
       }
       sprites[p]->fframe+=sprites[p]->framerate;
       if (sprites[p]->fframe>(sprites[p]->numframes)) sprites[p]->fframe-=(sprites[p]->numframes);
       sprites[p]->current_frame=sprites[p]->fframe;
       }

     }


     if (sprites[p]->mode==FLYING)
     {
       if (fx>(sprites[p]->x-sprites[p]->parameter) && fx<(sprites[p]->x+sprites[p]->w+sprites[p]->parameter))
       {
         sprites[p]->fframe+=sprites[p]->framerate;
         if (sprites[p]->fframe>(sprites[p]->numframes)) sprites[p]->fframe=4.0;
         sprites[p]->current_frame=sprites[p]->fframe;
         if (sprites[p]->fframe>=4.0)
         {

           r=rand()%4;
         //  printf("%i ",r);
           if (r==0) {sprites[p]->x++;}// if (sprites[p]->x>(sprites[p]->originalx+sprites[p]->parameter)) sprites[p]->x--;}
           if (r==1) {sprites[p]->x--;} //if (sprites[p]->x<(sprites[p]->originalx-sprites[p]->parameter)) sprites[p]->x++;}
           if (r==2) {sprites[p]->y++;}// if (sprites[p]->y>(sprites[p]->originaly+sprites[p]->parameter)) sprites[p]->y--;}
           if (r==3) {sprites[p]->y--;}// if (sprites[p]->y<(sprites[p]->originaly-sprites[p]->parameter)) sprites[p]->y++;}
         }
       } else {
         if (sprites[p]->x>sprites[p]->originalx) sprites[p]->x--;
         if (sprites[p]->x<sprites[p]->originalx) sprites[p]->x++;
         if (sprites[p]->y>sprites[p]->originaly) sprites[p]->y--;
         if (sprites[p]->y<sprites[p]->originaly) sprites[p]->y++;

         if ((sprites[p]->x==sprites[p]->originalx) && (sprites[p]->y==sprites[p]->originaly))
         {
           sprites[p]->fframe-=sprites[p]->framerate;
           if (sprites[p]->fframe<0) sprites[p]->fframe=0.0;
           sprites[p]->current_frame=sprites[p]->fframe;
         } else {
           sprites[p]->fframe+=sprites[p]->framerate;
           if (sprites[p]->fframe>(sprites[p]->numframes)) sprites[p]->fframe=4.0;
           sprites[p]->current_frame=sprites[p]->fframe;
         }
       }
     }
     if (sprites[p]->mode==NEARONCE)
     {
       if (fx>(sprites[p]->x-sprites[p]->parameter))
       {
         if (!sprites[p]->plain)
         {
           sprites[p]->fframe+=sprites[p]->framerate;
           if (sprites[p]->fframe>(sprites[p]->numframes)) sprites[p]->fframe=7.0;
           sprites[p]->current_frame=sprites[p]->fframe;
         } else {
           sprites[p]->current_frame++;
           if (sprites[p]->current_frame>7) sprites[p]->current_frame=7;
         }
       }
     }
     if (sprites[p]->mode==FLYINGBUG)
     {
       if (fx>(sprites[p]->x-sprites[p]->parameter) && fx<(sprites[p]->x+sprites[p]->w+sprites[p]->parameter))
       {
         sprites[p]->fframe+=sprites[p]->framerate;
       }
       if (sprites[p]->fframe>0.0)
       {
         sprites[p]->fframe+=sprites[p]->framerate;
         if (sprites[p]->fframe>(sprites[p]->numframes)) sprites[p]->fframe=4.0;
         sprites[p]->current_frame=sprites[p]->fframe;
         if (sprites[p]->y>20) sprites[p]->y-=1;
       }
       if (sprites[p]->fframe>=4.0)
         {
           r=rand()%4;
       //    printf("%i ",r);
           if (r==0) {sprites[p]->x++;}// if (sprites[p]->x>(sprites[p]->originalx+sprites[p]->parameter)) sprites[p]->x--;}
           if (r==1) {sprites[p]->x--;} //if (sprites[p]->x<(sprites[p]->originalx-sprites[p]->parameter)) sprites[p]->x++;}
           if (r==2) {sprites[p]->y++; if (sprites[p]->y>80) sprites[p]->y--;}
           if (r==3) {sprites[p]->y--; if (sprites[p]->y<0) sprites[p]->y++;}
         }

     }
     if (sprites[p]->mode==TRIGGERONCE)
     {
       if (fx>(sprites[p]->parameter))
       {
         if (!sprites[p]->plain)
         {
           sprites[p]->fframe+=sprites[p]->framerate;
           if (sprites[p]->fframe>(sprites[p]->numframes)) sprites[p]->fframe=7.0;
           sprites[p]->current_frame=sprites[p]->fframe;
         } else {
           sprites[p]->current_frame++;
           if (sprites[p]->current_frame>7) sprites[p]->current_frame=7;
         }
       }
     }
     sx=fx-sprites[p]->x;
     sy=fy-sprites[p]->y;
     if (sx<sprites[p]->w && sy<sprites[p]->h && sx>0 && sy>0)
     {
       if (sprites[p]->image[sx+(sprites[p]->w*sprites[p]->current_frame)][sy][3]>20 && !gameover) {gameover=50;fparameter=10.0;explode_firefly();}
     }
     if (sprites[p]->current_frame>7) sprites[p]->current_frame=7;
     if (sprites[p]->current_frame>7) sprites[p]->current_frame=7;
   }
   for (p=0;p<sprite_connections_count;p++)
   {
     sprites[sprite_connections[p][1]]->x=sprites[sprite_connections[p][0]]->x+sprite_connections[p][2];
     sprites[sprite_connections[p][1]]->y=sprites[sprite_connections[p][0]]->y+sprite_connections[p][3];
     sprites[sprite_connections[p][1]]->current_frame=sprites[sprite_connections[p][0]]->current_frame;
   }

   for (p=0;p<NUMLIGHTS;p++)
   {
     lights[p].phase+=lights[p].wave;
     lights[p].sine=(fparameter<1.0 ? fparameter : 1.0)*lights[p].light+(sin(lights[p].phase)*lights[p].range);
     if (fparameter<=0.0) lights[p].sine=0.0;
   }

   if (key[KEY_Q]) printf("%f %i\n",sprites[0]->fframe,sprites[0]->current_frame);


  if (gameover) {fmx=fly;fmy=fly;mx=fx;my=fy;}



   gameover--;
   if (gameover==1) {header->duration=0;footer->duration=0;beginlevel(current_level,1);gameover--;}
   if (gameover<0) gameover=0;

  if (DEBUGMODE) gameover=0; ///////////////////////////////////////////////////


}

void timer()
{
	tim++;
}
END_OF_FUNCTION(timer);

int main(int argc, char *argv[])
{
    int c,i,frame;
    char sshot[64];
    SAMPLE *alleluya;
    BITMAP *shot;
  printf("******************************\n");
  printf("*         FIREFLIES          *\n");
  printf("******************************\n");
  printf("Initializing\n");

  printf("Allegro Init");printf(" OK!\n");
	  allegro_init();
	//  alogg_init();
	printf("  keyboard...");
    install_keyboard();
  printf(" OK!\n");

  printf("  interrupts...");
    install_timer();
  printf(" OK!\n");

  printf("  mouse...");
    install_mouse();
  printf(" OK!\n");

  printf("  sound...");
     FSOUND_Init (44100, 32, 0);

    c=install_sound(DIGI_AUTODETECT, MIDI_NONE, argv[0]);
     glass= load_wav("glass.wav");
    //play_sample(glass,255,128,1000,1);
    if(!c) printf("NO SOUND!");
    set_color_depth(32);
    set_gfx_mode((FULLSCREEN ? GFX_AUTODETECT_FULLSCREEN : GFX_AUTODETECT_WINDOWED), 640,480, 0, 0);
    set_color_conversion(COLORCONV_TOTAL);
    srand(time(NULL));
  printf(" OK!\n");

  printf("  font rendering...");
   letters = load_bitmap_font("font.bmp",NULL,NULL);
   header = malloc(sizeof(HDTEXT));
   footer = malloc(sizeof(HDTEXT));
   header->render = create_bitmap(160,20);
   header->bump = create_bitmap(160,20);
   footer->render = create_bitmap(160,20);
   footer->bump = create_bitmap(160,20);
  printf(" OK!\n");

  printf("  video pages...");
  // page1 = create_video_bitmap(SCREEN_W, SCREEN_H);
  // page2 = create_video_bitmap(SCREEN_W, SCREEN_H);
 //  if ((!page1) || (!page2)) {printf("Unable to create two video memory pages\n");return 1;}
 shot = create_bitmap(160,80);
   active_page = create_bitmap(160,120);
   if (!active_page) {printf("buffer failed");return 1;} else printf("buffer dimensions: %i x %i...",active_page->w,active_page->h);
   clear_to_color(active_page,makecol(255,255,255));
  printf(" OK!\n");

  printf("  interrupt setup...");
    install_int_ex(timer, BPS_TO_TIMER(30));
    LOCK_FUNCTION(timer);
    LOCK_VARIABLE(tim);
  printf(" OK!\n");
  printf("Setting up camera...");
  if (!mouse_driven) setup_camera();
  printf("DONE!\n");

  printf("Starting up...");
    beginlevel(current_level,0);
    frame=0;
    while(!key[KEY_ESC])
    {
      clear_to_color(active_page, makecol(0,0,0));

    /* ret = alogg_update_streaming(stream);

      if (ret==0)
      {
        printf("song ednded!!!!!!");
        alogg_stop_streaming(stream);
        if (current_level==1) stream=alogg_start_streaming("excavation.ogg",BLOCK_SIZE);
        if (current_level==2) stream=alogg_start_streaming("woodland.ogg",BLOCK_SIZE);
        if (current_level==3) stream=alogg_start_streaming("leni.ogg",BLOCK_SIZE);
        if (current_level==4) stream=alogg_start_streaming("lurking.ogg",BLOCK_SIZE);
        if (current_level==5) stream=alogg_start_streaming("mario.ogg",BLOCK_SIZE);
      }*/
      while (tim >0)
      {
	      timer_proc();
	      tim--;
  	  }
  	  check_lvl();
      rysuj();

      //sensitivity=200+mouse_z;
      if (!mouse_driven) find_candle();
      if (key[KEY_S])
      {
        blit(active_page,shot,0,20,0,0,160,80);
      sprintf(sshot,"sss\\shot%04i.bmp",frame);frame++;
      save_bmp(sshot,shot,NULL);
      }
      //show_video_bitmap(active_page);
     if (mouse_driven) putpixel(active_page,mouse_x/4,mouse_y/4+20,makecol(255,255,255));
      stretch_blit(active_page, screen, 0, 0,160,120, 0, 0, SCREEN_W, SCREEN_H);
  //    textprintf_ex(screen, font, 10, 10  , makecol(128, 255, 64), -1, "Sensitivity: %i",sensitivity);
 if (DEBUGTEXT) {
  textprintf_ex(screen, font, 10, 10  , makecol(128, 255, 64), -1, "Stamina: %i",fstamina);
  textprintf_ex(screen, font, 10, 20  , makecol(128, 255, 64), -1, "X: %3.2f %i %1.3f",flx,fx,fvx);
  textprintf_ex(screen, font, 10, 30  , makecol(128, 255, 64), -1, "Y: %3.2f %i %1.3f",fly,fy,fvy);
  textprintf_ex(screen, font, 10, 40  , makecol(128, 255, 64), -1, "MX: %1.2f",fmx);
  textprintf_ex(screen, font, 10, 50  , makecol(128, 255, 64), -1, "MY: %1.2f",fmy);
  textprintf_ex(screen, font, 10, 60  , makecol(128, 255, 64), -1, "cnd: %i",candlesize);
  textprintf_ex(screen, font, 10, 70  , makecol(128, 255, 64), -1, "scr: %i",scroll);
    }
      vsync();
   //   if (active_page == page1)
	// 	active_page = page2;
    //  else
	// 	active_page = page1;
    }

   // alogg_stop_streaming(stream);
    remove_timer();
    remove_sound();
       FSOUND_Close();

  //  alogg_exit();
    if (!mouse_driven) {
#ifdef linux
	type = V4L2_BUF_TYPE_VIDEO_CAPTURE;
	xioctl(fd, VIDIOC_STREAMOFF, &type);
	for (i = 0; i < n_buffers; ++i)
		v4l2_munmap(buffers[i].start, buffers[i].length);
	v4l2_close(fd);
#endif
#ifdef _WIN32
cvReleaseCapture( &capture );
#endif
    }
    allegro_exit();
    return 0;
}
END_OF_MAIN();

