#include <stdio.h>
#include <allegro.h>
#include <winalleg.h>
#include  "portaudio/portaudio.h"

#define FREQ 22000
#define BITS 8
#define STEREO 1

#define PA_SAMPLE_TYPE  paInt16

#define SAMPLE_RATE  (8000)
//#define SAMPLE_RATE  (16000)
//#define SAMPLE_RATE  (32000)

// I think one buffer has to be full (of samples) before you hear the sound.
// So higher frames per buffer means that there will be a larger latency before you hear the sound
// However, it would lock and unlock the buffer more often, hindering performance.
#define FRAMES_PER_BUFFER  (2048 / (32000 / SAMPLE_RATE))

#define AMPLITUDE_THRESHOLD 0xff
#define AMOUNT_THRESHOLD 0xff

// #define PA_ERR(x) {if ((x)!=paNoError) LOG("[Voice] Portaudio error #" + TOSTR(err) + std::string(" : ") + Pa_GetErrorText((x))); else LOG("[Voice] Paudio OK!");}

#define ABS(a) ((a)<0?-(a):a)


#define NUMSPRITES 16
#define MAXGHOSTSPEED 8
#define MAXBOYSPEED 2

PaStream *stream;
BITMAP *page1,*page2,*active_page;
volatile int tim;
BITMAP *sound_debug,*bg,*altar_boy,*ghost;
int sound_size;
int sprites[NUMSPRITES][2];
int scare_ratio=0;
int boy[2];

int PACallback( void *inputBuffer, void *outputBuffer,
													 unsigned long framesPerBuffer,
													 PaTimestamp outTime, void *userData )
{
    int c;
    short *buffer=inputBuffer;
		long loudness=0;
		float percent;
		// printf("Got sound frame!\n",percent);
	if (inputBuffer)
	{

        clear_to_color(sound_debug,makecol(255,0,255));
		for (c=0;c<FRAMES_PER_BUFFER;c++)
		{
			if (abs(buffer[c])<AMPLITUDE_THRESHOLD) loudness++;
            char s = buffer[c]>>8;
			vline(sound_debug,c,128,128+s,makecol(255,255,255));
			//loudness+=buffer[c];
		}
        scare_ratio = loudness-5;
        printf("Sound level: %f %i\n",percent,scare_ratio);

		if (loudness)
		{
			percent=(100.0*loudness)/FRAMES_PER_BUFFER;



		}

	}
	return 0;
}

void rysuj()
{
    int c;
    blit(bg, active_page, 0, 0, 0, 0, bg->w, bg->h);
    masked_blit(sound_debug, active_page, 0, 0, 0, 0, sound_debug->w, sound_debug->h);
    for (c=0;c<NUMSPRITES;c++)
    {
        draw_sprite(active_page,ghost,sprites[c][0]-ghost->w,sprites[c][1]-ghost->h);
    }
     draw_sprite(active_page,altar_boy,boy[0],boy[1]);
}

void draw_debug_sound()
{
    int c=0;
    char* buf;

}

void timer_proc()
{
    int c;
    for (c=0;c<NUMSPRITES;c++)
    {
        int x,y;
        x = boy[0]-sprites[c][0];
        y = boy[1]-sprites[c][1];
        x*=scare_ratio;
        y*=scare_ratio;
        x/=40;
        y/=40;
        if (x>MAXGHOSTSPEED) x=MAXGHOSTSPEED;
        if (x<-MAXGHOSTSPEED) x=-MAXGHOSTSPEED;
        if (y>MAXGHOSTSPEED) y=MAXGHOSTSPEED;
        if (y<-MAXGHOSTSPEED) y=-MAXGHOSTSPEED;
        sprites[c][0]+=x;
        sprites[c][1]+=y;

        if (sprites[c][0]<0) sprites[c][0]=0;
        if (sprites[c][1]<0) sprites[c][1]=0;
        if (sprites[c][0]>SCREEN_W) sprites[c][0]=SCREEN_W;
        if (sprites[c][1]>SCREEN_H) sprites[c][1]=SCREEN_H;
    }
}

void timer()
{
	tim++;
}
END_OF_FUNCTION(timer);

void init()
{
    int c;
    PaError pae;
    sound_debug = create_bitmap(FRAMES_PER_BUFFER,256);
    clear_to_color(sound_debug,makecol(0,0,0));
    pae = Pa_Initialize();
    printf("Initialising PA: %s\n",Pa_GetErrorText(pae));
    pae= Pa_OpenStream(
		&stream,
		Pa_GetDefaultInputDeviceID(),
		1, // Num channels, whatever that means
		PA_SAMPLE_TYPE,
		NULL,
		Pa_GetDefaultOutputDeviceID(),
		1, // Num channels
		PA_SAMPLE_TYPE,
		NULL,
		SAMPLE_RATE,
		FRAMES_PER_BUFFER,            /* frames per buffer */
		0,               /* number of buffers, if zero then use default minimum */
		0, /* paDitherOff, // flags */
		PACallback,
		0 );
		printf("Opening PA: %s\n",Pa_GetErrorText(pae));
    pae = Pa_StartStream( stream );
    printf("Starting PA: %s\n",Pa_GetErrorText(pae));

    ghost = load_bmp("ghost.bmp",0);
    bg = load_bmp("bg.bmp",0);
    altar_boy = load_bmp("altarboy.bmp",0);
    for (c=0;c<NUMSPRITES;c++)
    {
        sprites[c][0]=rand()%640;
        sprites[c][1]=rand()%480;
    }
    boy[1]=SCREEN_H-altar_boy->h;
    boy[0]=(SCREEN_W-altar_boy->w)/2;
}

int main(int argc, char *argv[])
{

	allegro_init();
    install_keyboard();
    install_timer();
    install_mouse();
    install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, argv[0]);

    srand(time(NULL));
        set_color_depth(32);
    set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0);


   page1 = create_video_bitmap(SCREEN_W, SCREEN_H);
   page2 = create_video_bitmap(SCREEN_W, SCREEN_H);

   if ((!page1) || (!page2)) {
      set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
      allegro_message("Unable to create two video memory pages\n");
      return 1;
   }

    init();

    install_int_ex(timer, BPS_TO_TIMER(30));
    LOCK_FUNCTION(timer);
    LOCK_VARIABLE(tim);

    active_page = page2;

    while(!key[KEY_ESC])
    {
      clear_to_color(active_page, makecol(255, 255, 255));



      while (tim >0)
      {
	      timer_proc();
	      tim--;
  	  }

      rysuj();
      draw_debug_sound();

      show_video_bitmap(active_page);

      if (active_page == page1)
	 	active_page = page2;
      else
	 	active_page = page1;

        // vsync();
        Sleep(1);
   }

    Pa_CloseStream( stream );
	Pa_Terminate();
    remove_timer();
    remove_sound();
    allegro_exit();
    return 0;
}
END_OF_MAIN();

